@extends('includes.adminlayout')

@section('content')
<main>
  <style>
    .avatars {
      vertical-align: middle;
       !important width: 300px;
       !important height: 300px;
       !important border-radius: 30%;
       !important text-align: center;
       !important
    }

    .center {
      margin: auto;
       !important
    }
  </style>
  <div class="container">
    <div class="card">
      <div class="card-body">
        <h3 class="text-center">User Detail</h3>
        <div class="col-md-12 col-12 ">
          <div class="d-flex flex-column align-items-center text-center p-3 py-5">
            <img class="rounded-1" width="200px" src="{{ $user_details->profile_image }}">
          </div>
        </div>
        <table class="table table-bordered mb-0">
          <thead class="thead-dark">
            <tr>
              <th>Item</th>
              <th>Detail</th>
            </tr>
          </thead>
          <tbody class="list">
            <tr>
              <td>Name</td>
              <td>{{ $user->name }} </td>
            </tr>
            <tr>
              <td>Email</td>
              <td>{{ $user->email }} </td>
            </tr>
            <tr>
              <td>Username</td>
              <td>{{ $user->username }} </td>
            </tr>
            <tr>
              <td>Password</td>
              <td>{{ $user->password_text }} </td>
            </tr>
            <tr>
              <td>Gender</td>
              <td>{{ $user_details->gender }}</td>
            </tr>
            <tr>
              <td>Phone Number</td>
              <td>{{ $user->phone_number }} </td>
            </tr>
            <tr>
              <td>Account Number</td>
              <td>{{ $user->account_number }} </td>
            </tr>
            <tr>
              <td>Account Type</td>
              <td>{{ ucfirst($user_details->account_type) }}</td>
            </tr>
            <tr>
              <td>Balance</td>
              <td>{{ $user->total_balance }}</td>
            </tr>
            </tr>
            <tr>
              <td>TAC code</td>
              <td>{{ $user_details->codes->tac }}</td>
            </tr>
            <tr>
              <td>TAX Code</td>
              <td>{{ $user_details->codes->tax }}</td>
            </tr>
            <tr>
              <td>Insurance Code</td>
              <td>{{ $user_details->codes->insurance ?? 'Not generated yet for any transaction.' }}</td>
            </tr>
            <tr>
              <td>Active OTP</td>
              <td>{{ $user->otp?->code ?? 'No active OTP.' }}</td>
            </tr>
            <tr>
              <td>Account Creation Date</td>
              <td>{{ $user->created_at }}</td>
            </tr>
            <tr>
              <td>Status</td>
              <td> <span @class([ 'badge' , 'bg-success'=> $user->is_active,
                  'bg-danger' => !$user->is_active,
                  ])>{{ userStatus($user->is_active) }}
                </span></td>
            </tr>
            <tr x-data="validate_transfer">
              <td>Validate Transfer</td>

              <td>
                <div class="form-check form-switch" x-init="user_id=@js($user->id)">
                  <input class="form-check-input" type="checkbox" role="switch" id="flexSwitchCheckChecked"
                    @checked($user_details->permissions->validate_transfer ?? '') x-model="validate_change"
                  @change="change">
                  <div class="spinner-border text-primary" role="status" style="width: 20px; height: 20px;"
                    x-show="processing" x-cloak>
                    <span class="visually-hidden">Loading...</span>
                  </div>
                </div>
              </td>
            </tr>
            <tr class="text-center">
              <td colspan="2">
                <div class="row">
                  <div class="col-md-4"><a class="btn btn-danger" href="{{ route('admin.user-delete', $user->id) }}">Remove User</a></div>
                  <div class="col-md-4"><a class="btn btn-primary" href="{{ route('admin.user-edit', $user->id) }}">Edit User Details</a></div>
                  <div class="col-md-4"><a class="btn btn-warning" href="{{ route('admin.user-login', $user->id) }}" target="_blank">Login as User</a></div>
                </div>
              </td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</main>
@endsection