<x-layouts.dashboard-inner title="Bank Statement" columns="12">
    <div class="modal-account__pane-header " style="background-color:rgb(217, 0, 0); padding:10px;">
        <h4 style="color: #ffffff; font-size: 18px;">Account Statement:</h4>
        <h4 class="float-right"><a class="modal__close text-primary" id="d-pdf">
                <svg class="icon-icon-print">
                    <use xlink:href="#icon-print"></use>
                </svg>
            </a>
        </h4>
    </div>

    <h6 class="ml-4 text-danger">Transfer history:</h6>
    <div class="modal-account__right tab-content">
        <div class="modal-account__pane tab-pane show active" id="accountDetails">
            <div class="card-order__product scrollbar-thin scrollbar-visible" data-simplebar>
                <table class="table table--lines table--groups table--striped">
                    <colgroup>
                        <col class="colgroup-1">
                        <col class="colgroup-2">
                        <col>
                        <col>
                        <col>
                    </colgroup>
                    <thead class="table__header">
                        <tr class="table__header-row">
                            <th><span class="text-nowrap">Ref No.</span>
                            </th>
                            <th><span class="text-nowrap">Sender Name</span>
                            </th>
                            <th class="text-center"><span>Tnx Type</span>
                            </th>
                            <th class="text-center"><span>Amount($)</span>
                            </th>
                            <th class="text-center"><span>Bank Name</span>
                            </th>
                            <th class="text-center"><span>Acccount Name</span>
                            </th>
                            <th class="text-center"><span>Account Number</span>
                            </th>
                            <th class="text-center"><span>Description</span>
                            </th>
                            <th class="text-center"><span>STATUS</span>
                            </th>
                            <th class="text-center"><span>Date</span>
                            </th>
                            <th class="table__actions"></th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($transactions as $transaction)
                        <tr class="table__row">
                            <td class="table__td">{{ $transaction->txn_id }}</td>
                            <td class="table__td text-center text-dark-theme">{{ $transaction->user->name }}</td>
                            <td class="table__td text-center text-dark-theme">{{ $transaction->type }} Transfer</td>
                            <td class="table__td text-center">
                                <div><span class="text-dark-theme">{{ $transaction->total_amount }}</span>
                                </div>
                            </td>
                            <td class="table__td text-nowrap text-dark-theme">{{ $transaction->details->receiving_bank }}</td>
                            <td class="table__td text-nowrap text-dark-theme">{{ $transaction->details->beneficiary_name }}</td>
                            <td class="table__td text-nowrap text-dark-theme">{{ $transaction->details->beneficiary_account_number }}</td>
                            <td class="table__td text-nowrap text-dark-theme">{{ $transaction->short_description }}</td>
                            <td class="table__td ">
                                <span @class(['badge text-white', 
                                    'bg-success' => $transaction->status=='successful',
                                    'bg-warning' => $transaction->status=='cancelled',
                                    'bg-danger' => $transaction->status=='rejected',
                                    'bg-info' => $transaction->status=='pending',
                                    'bg-secondary' => $transaction->status=='expired',

                                ])>
                                    {{ $transaction->status }}
                                </span>
                            </td>
                            <td class="table__td text-nowrap text-dark-theme">{{ $transaction->date }}</td>
                            <td class="table__td table__actions text-dark-theme"> <a href="{{ route('transfer.details', $transaction->txn_id) }}"
                                    class="table__remove text-danger" type="button">
                                    <svg class="icon-icon-view">
                                        <use xlink:href="#icon-view"></use>
                                    </svg> 
                            </a>
                            </td>
                        </tr>

                        @empty

                        <td colspan="11" class="text-center"> No transactions yet. </td>
                        @endforelse
                </table>
            </div>
            {{ $transactions->links() }}
            <div class="card-order__footer-total">
                <div class="card__container">
                    <div class="row gutter-bottom-sm justify-content-end">
                        <div class="card-order__footer-submit col-12 col-sm">
                            <!-- <a href="index.php" class="button button--secondary" type="button"><span class="button__text">View Dashboard</span> -->
                            <a href="index.php" class="my-btn" type="button"><span class="button__text">View
                                    Dashboard</span>
                            </a>
                        </div>
                        <div class="col-12 col-sm-auto">
                            <ul class="card-order__total">
                                <li class="card-order__total-item">
                                    <div class="card-order__total-title">Balance:</div>
                                    <div class="card-order__total-value">{{ $user->total_balance }}</div>
                                </li>
                                <li class="card-order__total-item">
                                    <div class="card-order__total-title">TAX(0%):</div>
                                    <div class="card-order__total-value">$0</div>
                                </li>
                                <li class="card-order__total-item">
                                    <div class="card-order__total-title">DISCOUNT:</div>
                                    <div class="card-order__total-value">20%</div>
                                </li>
                                <li class="card-order__total-item card-order__total-footer">
                                    <div class="card-order__total-title">Total Balance:</div>
                                    <div class="card-order__total-value">{{ $user->total_balance }}</div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-layouts.dashboard-inner>