@props(['notification'])
<div class="dropdown-menu__item">
    <a class="dropdown-menu__item-remove" href="{{ route('dashboard.read-notification', $notification->id) }}">
        <svg class="icon-icon-cross">
            <use xlink:href="#icon-cross"></use>
        </svg>
    </a>
    <a class="dropdown-menu__item-block dropdown-menu__message" href="{{ route('dashboard.read-notification', $notification->id) }}">
        <div class="dropdown-menu__item-left">
            <div class="dropdown-menu__item-icon color-teal">
                <div class="dropdown-menu__item-icon-text">{{ substr($notification->data['title'], 0, 1); }}</div>
            </div>
            <div class="badge-signal badge-signal--green"></div>
        </div>
        <div class="dropdown-menu__item-right">
            <div class="dropdown-menu__item-column">
                <h4 class="dropdown-menu__item-title">{{ $notification->data['title'] }}</h4>
                <p class="dropdown-menu__text">{!! $notification->data['message'] !!}</p>
            </div><span class="dropdown-menu__item-time">{{ $notification->created_at->diffForHumans() }}</span>
        </div>
    </a>
</div>