@extends('includes.adminlayout')
@section('content')
<div class="container-fluid">

    <div class="d-flex align-items-baseline justify-content-between">

        <!-- Title -->
        <h1 class="h2">
            Edit Account ({{ $user->name }})
        </h1>

        <!-- Breadcrumb -->
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                <li class="breadcrumb-item active" aria-current="page">Account</li>
            </ol>
        </nav>
    </div>

    <div class="row">
        <div class="col-md-4 col-xxl-3">

            <!-- Card -->
            <div class="card border-0 sticky-md-top top-10px">
                <div class="card-body">
                    <div class="text-center mb-5">
                        <div class="avatar avatar-xxl avatar-circle mb-5">
                            <label class="d-block cursor-pointer">
                                <span
                                    class="position-absolute bottom-0 end-0 m-0 bg-primary text-white w-30px h-30px rounded-circle d-flex align-items-center justify-content-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" height="14" width="14">
                                        <g>
                                            <path
                                                d="M2.65,16.4a.5.5,0,0,0-.49-.13.52.52,0,0,0-.35.38L.39,23a.51.51,0,0,0,.6.6l6.36-1.42a.52.52,0,0,0,.38-.35.5.5,0,0,0-.13-.49Z"
                                                style="fill: currentColor" />
                                            <path
                                                d="M17.85,7.21l-11,11a.24.24,0,0,0,0,.35l1.77,1.77a.5.5,0,0,0,.71,0L20,9.68A.48.48,0,0,0,20,9L18.21,7.21A.25.25,0,0,0,17.85,7.21Z"
                                                style="fill: currentColor" />
                                            <path
                                                d="M16.79,5.79,15,4a.48.48,0,0,0-.7,0L3.71,14.63a.51.51,0,0,0,0,.71l1.77,1.77a.24.24,0,0,0,.35,0l11-11A.25.25,0,0,0,16.79,5.79Z"
                                                style="fill: currentColor" />
                                            <path
                                                d="M22.45,1.55a4,4,0,0,0-5.66,0l-.71.71a.51.51,0,0,0,0,.71l5,4.95a.52.52,0,0,0,.71,0l.71-.71A4,4,0,0,0,22.45,1.55Z"
                                                style="fill: currentColor" />
                                        </g>
                                    </svg>
                                </span>
                                <form action="{{ route('admin.avatar') }}" method="POST" enctype="multipart/form-data"
                                    id="adminAvatarUpload">
                                    @csrf
                                    <input type="file" name="avatar" id="avatar" class="d-none">
                            </label>
                            <img src="{{ $user->details->avatar }}" alt="" class="avatar-img" width="80%">
                            <a id="submitButton" href="javascript:void(0);" onclick="$(this).closest('form').submit();"
                                style="font-size: 10px; display:none">Upload Image </a>
                            </form>
                        </div><br><br>
                        <h3 class="mb-0">{{ $user->name }}</h3>
                        <span class="small text-secondary fw-semibold">{{ ucfirst($user_details->account_type) }}
                            Account </span><br>
                        <span class="small text-secondary fw-semibold">Account Number: {{ $user->account_number
                            }}</span><br>
                        <hr>

                        <b>Account Balance:</b> {{ $user->total_balance }}
                    </div>

                    <!-- Divider -->
                    <hr class="mb-0">
                </div>

                <ul class="scrollspy mb-5" id="account" data-scrollspy='{"offset": "30"}'>
                    <li class="active">
                        <a href="#basicInformationSection" class="d-flex align-items-center py-3">
                            <svg viewBox="0 0 24 24" height="14" width="14" class="me-3"
                                xmlns="http://www.w3.org/2000/svg">
                                <path d="M6.750 6.000 A5.250 5.250 0 1 0 17.250 6.000 A5.250 5.250 0 1 0 6.750 6.000 Z"
                                    fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                    stroke-width="1.5" />
                                <path d="M2.25,23.25a9.75,9.75,0,0,1,19.5,0" fill="none" stroke="currentColor"
                                    stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" />
                            </svg>
                            Basic information
                        </a>
                    </li>

                    <li>
                        <a href="#passwordSection" class="d-flex align-items-center py-3">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" height="14"
                                width="14" class="me-3">
                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                    stroke-width="1.5"
                                    d="M18.75 9.75H5.25C4.42157 9.75 3.75 10.4216 3.75 11.25V21.75C3.75 22.5784 4.42157 23.25 5.25 23.25H18.75C19.5784 23.25 20.25 22.5784 20.25 21.75V11.25C20.25 10.4216 19.5784 9.75 18.75 9.75Z" />
                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                    stroke-width="1.5"
                                    d="M6.75 9.75V6C6.75 4.60761 7.30312 3.27226 8.28769 2.28769C9.27226 1.30312 10.6076 0.75 12 0.75C13.3924 0.75 14.7277 1.30312 15.7123 2.28769C16.6969 3.27226 17.25 4.60761 17.25 6V9.75" />
                                <path stroke="currentColor" stroke-width="1.5"
                                    d="M8.625 15C8.41789 15 8.25 14.8321 8.25 14.625C8.25 14.4179 8.41789 14.25 8.625 14.25" />
                                <path stroke="currentColor" stroke-width="1.5"
                                    d="M8.625 15C8.83211 15 9 14.8321 9 14.625C9 14.4179 8.83211 14.25 8.625 14.25" />
                                <path stroke="currentColor" stroke-width="1.5"
                                    d="M8.625 18.75C8.41789 18.75 8.25 18.5821 8.25 18.375C8.25 18.1679 8.41789 18 8.625 18" />
                                <path stroke="currentColor" stroke-width="1.5"
                                    d="M8.625 18.75C8.83211 18.75 9 18.5821 9 18.375C9 18.1679 8.83211 18 8.625 18" />
                                <path stroke="currentColor" stroke-width="1.5"
                                    d="M12 15C11.7929 15 11.625 14.8321 11.625 14.625C11.625 14.4179 11.7929 14.25 12 14.25" />
                                <path stroke="currentColor" stroke-width="1.5"
                                    d="M12 15C12.2071 15 12.375 14.8321 12.375 14.625C12.375 14.4179 12.2071 14.25 12 14.25" />
                                <g>
                                    <path stroke="currentColor" stroke-width="1.5"
                                        d="M12 18.75C11.7929 18.75 11.625 18.5821 11.625 18.375C11.625 18.1679 11.7929 18 12 18" />
                                    <path stroke="currentColor" stroke-width="1.5"
                                        d="M12 18.75C12.2071 18.75 12.375 18.5821 12.375 18.375C12.375 18.1679 12.2071 18 12 18" />
                                </g>
                                <g>
                                    <path stroke="currentColor" stroke-width="1.5"
                                        d="M15.375 15C15.1679 15 15 14.8321 15 14.625C15 14.4179 15.1679 14.25 15.375 14.25" />
                                    <path stroke="currentColor" stroke-width="1.5"
                                        d="M15.375 15C15.5821 15 15.75 14.8321 15.75 14.625C15.75 14.4179 15.5821 14.25 15.375 14.25" />
                                </g>
                                <g>
                                    <path stroke="currentColor" stroke-width="1.5"
                                        d="M15.375 18.75C15.1679 18.75 15 18.5821 15 18.375C15 18.1679 15.1679 18 15.375 18" />
                                    <path stroke="currentColor" stroke-width="1.5"
                                        d="M15.375 18.75C15.5821 18.75 15.75 18.5821 15.75 18.375C15.75 18.1679 15.5821 18 15.375 18" />
                                </g>
                            </svg>
                            Password
                        </a>
                    </li>

                    <li>
                        <a href="#creditDebitSection" class="d-flex align-items-center py-3">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" height="14" width="14"
                                class="me-3">
                                <defs>
                                    <style>
                                        .a {
                                            fill: none;
                                            stroke: currentColor;
                                            stroke-linecap: round;
                                            stroke-linejoin: round;
                                            stroke-width: 1.5px;
                                        }
                                    </style>
                                </defs>
                                <title>credit-card-1</title>
                                <rect class="a" x="0.75" y="3.75" width="22.5" height="16.5" rx="1.5" ry="1.5" />
                                <line class="a" x1="0.75" y1="8.25" x2="23.25" y2="8.25" />
                                <line class="a" x1="5.25" y1="12.75" x2="13.5" y2="12.75" />
                                <line class="a" x1="5.25" y1="15.75" x2="10.5" y2="15.75" />
                            </svg>
                            Credit/Debit Users
                        </a>
                    </li>

                    <li>
                        <a href="#deactivateAccount" class="d-flex align-items-center py-3">
                            <svg viewBox="0 0 24 24" height="14" width="14" class="me-3"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M18.177,23.25H7.677a1.5,1.5,0,0,1-1.5-1.5V8.25h13.5v13.5A1.5,1.5,0,0,1,18.177,23.25Z"
                                    fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                    stroke-width="1.5" />
                                <path d="M10.677 18.75L10.677 12.75" fill="none" stroke="currentColor"
                                    stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" />
                                <path d="M15.177 18.75L15.177 12.75" fill="none" stroke="currentColor"
                                    stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" />
                                <path d="M2.427 6.212L21.501 2.158" fill="none" stroke="currentColor"
                                    stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" />
                                <path
                                    d="M13.541.783l-4.4.935A1.5,1.5,0,0,0,7.984,3.5L8.3,4.965l7.336-1.56L15.32,1.938A1.5,1.5,0,0,0,13.541.783Z"
                                    fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                    stroke-width="1.5" />
                            </svg>
                            Deactivate account
                        </a>
                    </li>

                </ul>
            </div>
        </div>

        <div class="col">
            <form action="{{ route('admin.basic_info') }}" method="POST">
                @csrf
                <!-- Card -->
                <div class="card border-0 scroll-mt-3" id="basicInformationSection">
                    <div class="card-header">
                        <h2 class="h3 mb-0">Basic information</h2>
                    </div>

                    <div class="card-body">
                        <div class="row mb-4">
                            <div class="col-lg-3">
                                <label for="fullName" class="col-form-label">Full Name</label>
                            </div>

                            <div class="col-lg">
                                <x-form.input class="form-control" name="name" value="{{ $user->name }}" />
                            </div>
                        </div>

                        <div class="row mb-4">
                            <div class="col-lg-3">
                                <label for="phone" class="col-form-label">Phone</label>
                            </div>

                            <div class="col-lg">
                                <x-form.input class="form-control" name="phone_number" value="{{ $user->phone_number }}"
                                    placeholder="Please, enter your phone number" />
                            </div>
                        </div>

                        <div class="row mb-4">
                            <div class="col-lg-3">
                                <label for="email" class="col-form-label">Email address</label>
                            </div>

                            <div class="col-lg">
                                <x-form.input class="form-control" name="email" value="{{ $user->email }}" />
                            </div>
                        </div>

                        <div class="row mb-4">
                            <div class="col-lg-3">
                                <label for="email" class="col-form-label">Username</label>
                            </div>

                            <div class="col-lg">
                                <x-form.input class="form-control" name="username" value="{{ $user->username }}" />
                            </div>
                        </div>

                        <div class="row mb-4">
                            <div class="col-lg-3">
                                <label for="email" class="col-form-label">Pin</label>
                            </div>

                            <div class="col-lg">
                                <x-form.input class="form-control" name="pin" value="{{ $user->pin }}" />
                            </div>
                        </div>



                        <div class="row mb-4">
                            <div class="col-lg-3">
                                <label for="country" class="col-form-label">Country </label>
                            </div>

                            <div class="col-lg">
                                <div class="mb-4">
                                    <x-form.select name="country" class="form-select">
                                        @if($user_details->country == null)
                                        <option value="" selected>Select Country</option>
                                        @else
                                        <option value="{{ $user_details->country }}" selected>{{ $user_details->country
                                            }}</option>
                                        @endif
                                        @include('partials.register.countries')
                                    </x-form.select>
                                </div>
                            </div>
                        </div>


                        <div class="row mb-4">
                            <div class="col-lg-3">
                                <label class="col-form-label">Gender </label>
                            </div>

                            <div class="col-lg">
                                <div class="mb-4">
                                    <x-form.select name="gender" class="form-select">
                                        <option value="">Select Gender</option>
                                        <option value="male" @selected($user_details->gender=='male')>Male</option>
                                        <option value="female" @selected($user_details->gender=='female')>Female</option>
                                    </x-form.select>
                                </div>
                            </div>
                        </div>

                        <div class="row mb-4">
                            <div class="col-lg-3">
                                <label for="addressLine1" class="col-form-label">Address Line</label>
                            </div>

                            <div class="col-lg">
                                <x-form.input class="form-control" name="address" value="{{ $user_details->address }}"
                                    placeholder="Please, enter an address" />
                            </div>

                        </div>

                        <div class="row mb-4">
                            <div class="col-lg-3">
                                <label class="col-form-label">Date of Birth</label>
                            </div>

                            <div class="col-lg">
                                <x-form.input type="date" class="form-control" name="date_of_birth" value="{{ $user_details->date_of_birth->format('Y-m-d') }}" />
                            </div>
                        </div>

                        <div class="row mb-4">
                            <div class="col-lg-3">
                                <label class="col-form-label">Account Type </label>
                            </div>

                            <div class="col-lg">
                                <div class="mb-4">
                                    <x-form.select name="account_type" class="form-select">
                                        <option value="">Choose Account Type</option>
                                        <option value="savings" @selected($user_details->
                                            account_type=='savings')>Savings</option>
                                        <option value="current" @selected($user_details->
                                            account_type=='current')>Current</option>
                                        <option value="checking" @selected($user_details->
                                            account_type=='checking')>Checking</option>
                                        <option value="fixed deposit" @selected($user_details->account_type=='fixed
                                            deposit')>Fixed Deposit</option>
                                        <option value="non resident" @selected($user_details->account_type=='non
                                            resident')>Non-Resident</option>
                                        <option value="online banking" @selected($user_details->account_type=='online
                                            banking')>Online Banking</option>
                                        <option value="joint" @selected($user_details->
                                            account_type=='joint')>Joint Account</option>
                                        <option value="domiciliary" @selected($user_details->
                                            account_type=='domiciliary')>Domiciliary Account</option>
                                    </x-form.select>
                                </div>
                            </div>
                        </div>

                        <div class="row mb-4">
                            <div class="col-lg-3">
                                <label class="col-form-label">Marital Status</label>
                            </div>

                            <div class="col-lg">
                                <div class="mb-4">
                                    <x-form.select name="marital_status" class="form-select">
                                        <option value="">Change Marital Status</option>
                                        <option value="single" @selected($user_details->marital_status=='single')>Single
                                        </option>
                                        <option value="married" @selected($user_details->
                                            marital_status=='married')>Married</option>
                                        <option value="divorced" @selected($user_details->
                                            marital_status=='divorced')>Divorced</option>
                                        <option value="widowed" @selected($user_details->
                                            marital_status=='divorce')>Widowed</option>
                                    </x-form.select>
                                </div>
                            </div>
                        </div>

                        <div class="row mb-4">
                            <div class="col-lg-3">
                                <label class="col-form-label">Occupation</label>
                            </div>

                            <div class="col-lg">
                                <x-form.input class="form-control" name="occupation" value="{{ $user_details->occupation }}" />
                            </div>
                        </div>

                        <div class="row mb-4">
                            <div class="col-lg-3">
                                <label class="col-form-label">Currency</label>
                            </div>

                            <div class="col-lg">
                                <div class="mb-4">
                                    <x-form.select name="currency" class="form-select">
                                        <option value="">Select Currency</option>
                                        
                                        <option value="$" @selected($user_details->currency=='$')>Dollar </option>
                                        <option value="£" @selected($user_details->currency=='£')>Pound </option>
                                        <option value="€" @selected($user_details->currency=='€')>Euro</option>
                                    </x-form.select>
                                </div>
                            </div>
                        </div>

                        <div class="row mb-4">
                            <div class="col-lg-3">
                                <label class="col-form-label">SSN/TIN</label>
                            </div>

                            <div class="col-lg">
                                <x-form.input type="number" class="form-control" name="ssn" value="{{ $user_details->ssn }}" />
                            </div>
                        </div>

                        @foreach($user_details->codes as $code => $value)
                        <div class="row mb-4">
                            <div class="col-lg-3">
                                <label class="col-form-label"> {{ ucfirst($code )}} Code</label>
                            </div>

                            <div class="col-lg">
                                <x-form.input type="number" class="form-control" name="{{ $code }}" value="{{ $value }}" autocomplete="off" />
                            </div>
                        </div>
                        @endforeach

                        <div class="row mx-3">
                            @foreach ($user_details->permissions as $permission => $value)
                            <div class="form-check form-switch">
                                <input name="{{ $permission }}" type="hidden" value="0">
                                <input class="form-check-input" name="{{ $permission }}" type="checkbox" role="switch"  @checked($value) value="1">
                                <label class="form-check-label">{{ convertText($permission) }}</label>
                            </div>
                            @endforeach
                        </div>
                        <div class="form-check">
                            <input type="checkbox" class="form-check-input" name="send_mail" value="1">
                            <label class="form-label">
                                Send User Email Notification
                            </label>
                        </div>
                        <div class="d-flex justify-content-end mt-5">
                            <!-- Button -->
                            <button id="loading" class="btn btn-primary" type="button" disabled style="display: none">
                                <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                <span class="sr-only">Loading...</span>
                            </button>
                            <button id="done" type="submit" class="btn btn-primary">Save Changes</button>
                        </div>
                    </div>
                </div>
            </form>

            <form action="{{ route('admin.password') }}" method="POST">
                @csrf
                <div class="card border-0 scroll-mt-3" id="passwordSection">
                    <div class="card-header">
                        <h2 class="h3 mb-0">Password</h2>
                    </div>
                    <div class="card-body">

                        <div class="row mb-4">
                            <div class="col-lg-3">
                                <label for="password" class="col-form-label">New password</label>
                            </div>

                            <div class="col-lg">
                                <div class="input-group input-group-merge">
                                    <x-form.input type="password" class="form-control" name="password" autocomplete="off" placeholder="Your new password" />
                                </div>
                            </div>

                            <div class="col-lg">
                                <div class="input-group input-group-merge">
                                    <input type="password" class="form-control" name="password_confirmation" autocomplete="off" placeholder="Confirm your new password" />

                                    <button type="button" class="input-group-text px-4 text-secondary link-primary"
                                        data-toggle-password></button>
                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-end mt-5">
                            <button type="submit" class="btn btn-primary">Save Changes</button>
                        </div>
                    </div>
                </div>
            </form>

            <form action=" {{ route('admin.cred_deb') }} " method="POST">

                @csrf
                <!-- Card -->
                <div class="card border-0 scroll-mt-3" id="creditDebitSection">
                    <div class="card-header">
                        <h2 class="h3 mb-0"> Credit/Debit User</h2>
                    </div>
                    <div class="card-body">
                        <div class="row mb-4">
                            <div class="col-lg">
                                <label for="alert_type" class="form-label">Credit/Debit</label>
                                <x-form.select name="alert_type" id="alert_type" class="form-select">
                                    <option value="">Select One</option>
                                    <option value="credit">Credit</option>
                                    <option value="debit">Debit</option>
                                </x-form.select>
                            </div>
                            <div class="col-lg-12 mt-4">
                                <label for="amount" class="form-label">Amount</label>
                                <div class="input-group">
                                    <div class="input-group-text">{{ $user->details->currency }}</div>
                                    <x-form.input class="form-control" name="amount" :old="true" />
                                </div>
                            </div>
                            <div class="col-lg mt-4">
                                <label for="amount" class="form-label">Date</label></label>
                                <x-form.input type="date" class="form-control" name="date" value="{{ $now->format('Y-m-d') }}" :old="true" />
                            </div>
                            <div class="col-lg-12 mt-4">
                                <label for="note" class="form-label">Note</label>
                                <x-form.textarea name="note" cols="2" rows="3" class="form-control">{{ old('note') }}</x-form.textarea>
                            </div>
                        </div>
                        <div class="form-check">
                            <input type="checkbox" class="form-check-input" id="send_email" name="send_email" value="1">
                            <label class="form-label" for="flexCheckDefault">
                                Send User Email Notification
                            </label>
                        </div>
                        <div class="d-flex justify-content-end mt-5">
                            <button type="submit" class="btn btn-primary">Send Transaction</button>
                        </div>
                    </div>
                </div>
            </form>
            @if ($user->is_active)
            <div class="card border-0 scroll-mt-3" id="deactivateAccount">
                <div class="card-header">
                    <h2 class="h3 mb-0">Deactivate Account</h2>
                </div>

                <div class="card-body">
                    <div class="alert text-bg-danger-soft d-flex align-items-center" role="alert">
                        <div>
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" height="32" width="32"
                                class="me-3">
                                <path
                                    d="M23.39,10.53,13.46.6a2.07,2.07,0,0,0-2.92,0L.61,10.54a2.06,2.06,0,0,0,0,2.92h0l9.93,9.92A2,2,0,0,0,12,24a2.07,2.07,0,0,0,1.47-.61l9.92-9.92A2.08,2.08,0,0,0,23.39,10.53ZM11,6.42a1,1,0,0,1,2,0v6a1,1,0,1,1-2,0Zm1.05,11.51h0a1.54,1.54,0,0,1-1.52-1.47A1.47,1.47,0,0,1,12,14.93h0A1.53,1.53,0,0,1,13.5,16.4,1.48,1.48,0,0,1,12.05,17.93Z"
                                    style="fill: currentColor" />
                            </svg>
                        </div>
                        <div>
                            <h4 class="mb-0">If you deactivate a user account, user will no longer be able to login</h4>
                        </div>
                    </div>
                    <form method="POST" action="{{ route('admin.activate_deactivate') }}">
                        @csrf
                        <div class="mb-3">
                            <div class="form-check">

                                <!-- Input -->
                                <input type="checkbox" required class="form-check-input" id="deactivate_account"
                                    name="deactivate_account" value="1">

                                <!-- Label -->
                                <label class="form-check-label" for="deactivate_account">
                                    I confirm that I'd like to deactivate this account
                                </label>
                            </div>
                        </div>

                        <div class="d-flex justify-content-end mt-5">

                            <!-- Button -->
                            <button type="submit" class="btn btn-danger">Deactivate account</button>
                        </div>
                    </form>
                </div>
            </div>
            @else
            <div class="card border-0 scroll-mt-3" id="deactivateAccount">
                <div class="card-header">
                    <h2 class="h3 mb-0">Activate Account</h2>
                </div>

                <div class="card-body">
                    <div class="alert text-bg-success-soft d-flex align-items-center" role="alert">
                        <div>
                            <i class="material-icons mt-1 p-3">check</i>
                        </div>
                        <div>
                            <h4 class="mb-0">Activate user</h4>
                        </div>
                    </div>
                    <form method="POST" action=" {{ route('admin.activate_deactivate') }} ">
                        @csrf
                        <div class="mb-3">
                            <div class="form-check">

                                <!-- Input -->
                                <input required type="checkbox" class="form-check-input"  name="activate_account">

                                <!-- Label -->
                                <label class="form-check-label">
                                    I confirm that I'd like to activate this account
                                </label>
                            </div>
                        </div>

                        <div class="d-flex justify-content-end mt-5">

                            <!-- Button -->
                            <button type="submit" class="btn btn-success">Activate account</button>
                        </div>
                    </form>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>
@endsection