@extends('includes.adminlayout')
@section('content')
<div class="container">
    <div class="card">
        <div class="card-body">
            <h3 class="text-center">Deposit Method Details</h3>
            <hr>
            <form method="POST">
                @csrf
                <div class="row">
                    <div class="mb-3 col-md-4 mb-5 col-sm-12">
                        <label class="form-label">
                            Name
                        </label>
                        <x-form.input type="text" name="name" class="form-control" value="{{ $method->name }}" />
                    </div>

                    <div class="mb-3 col-md-4 mb-5 col-sm-12">
                        <label class="form-label">Type</label>
                        <x-form.select name="type" class="form-select" disabled>
                            <option value="">Select one</option>
                            <option value="crypto" @selected(old('type', $method->type)=='crypto')>Crypto</option>
                            <option value="bank" @selected(old('type', $method->type)=='bank')>Bank</option>
                        </x-form.select>
                    </div>

                    <div class="mb-3 col-md-4 mb-5 col-sm-12">
                        <label class="form-label">Status</label>
                        <x-form.select name="is_active" class="form-select">
                            <option value="">Select one</option>
                            <option value="1" @selected(old('is_active', $method->is_active))>Active</option>
                            <option value="0" @selected(old('is_active', !$method->is_active))>Inactive</option>
                        </x-form.select>
                    </div>

                    @foreach ($method->details as $detail => $value)
                    <div class="mb-3 col-md-4 mb-5 col-sm-12">
                        <label class="form-label">{{ convertText($detail) }}</label>
                            <x-form.input name="{{ $detail }}" class="form-control" value="{{ $value }}" required />
                    </div>
                    @endforeach

                        <div class="mb-3 col-12 d-flex mb-5 justify-content-end">
                            <a class="btn btn-danger mx-5"
                                href="{{ route('settings.deposit-methods.delete', $method->id) }}">Delete</a>
                            <button class="btn btn-primary">Submit</button>
                        </div>
                    </div>
            </form>
        </div>
    </div>
</div>
@endsection