<form @submit.prevent="sendMessage" x-data="contact_form" x-ref="contact_form" class="bdt-contact-form-form bdt-form-stacked bdt-grid bdt-grid-small without-recaptcha" data-bdt-grid="" method="post">
    <?php echo csrf_field(); ?>

    <div class="alert alert-danger" x-show="message.errors" x-cloak>
        <template x-for="(error, index) in message.errors" :key="index">
            <li>
                <span x-text="error"></span>
            </li>
        </template>
    </div>

    <div class="alert alert-success" x-show="message.success" x-text="message.success" x-cloak></div>

    <div class="bdt-field-group elementor-field-required bdt-width-1-1">
        <label for="user_name" class="bdt-form-label">Name*</label>

        <div class="bdt-form-controls">
            <input type="text" id="user_name" name="name" placeholder="ex: John Andrea" class="bdt-input bdt-form-large">
        </div>
    </div>

    <div class="bdt-field-group elementor-field-required bdt-width-1-1">
        <label for="email" class="bdt-form-label">Email*</label>
        <div class="bdt-form-controls">
            <input type="email" name="email" id="email" placeholder="ex: john@email.com" class="bdt-input bdt-form-large">
        </div>
    </div>


    <div class="bdt-field-group bdt-width-1-1 elementor-field-required">
        <label for="subject" class="bdt-form-label">Subject*</label>
        <div class="bdt-form-controls">
            <input type="text" name="subject" id="subject" placeholder="Renewal of Credit Card" class="bdt-input bdt-form-large">
        </div>
    </div>


    <div class="bdt-field-group bdt-width-1-1 elementor-field-required">
        <label for="message" class="bdt-form-label">Details*</label>
        <div class="bdt-form-controls">
            <textarea name="message" id="message" rows="5" placeholder="I need help with this" class="bdt-textarea bdt-form-large"></textarea>
        </div>
    </div>

    <div class="elementor-field-type-submit bdt-field-group bdt-flex bdt-width-1-1">
        <button type="submit" class="elementor-button bdt-button bdt-button-primary" name="submit">
            <span x-show="processing">Sending...</span>
            <span x-show="!processing">Send Message</span>
        </button>
    </div>
</form>

<script>
    document.addEventListener('alpine:init', () => {
        Alpine.data('contact_form', () => ({
            processing: false,
            message: {},
            
            async sendMessage() {
                this.processing = true;

                const form = this.$refs.contact_form
                const formData = new FormData(form)

                const payLoad = {
                    method: 'POST',
                    body: formData
                }
                try {
                    
                    const { status, message } = await (await fetch(route('pages.contact'), payLoad)).json()
                    this.message = message
                    this.processing = false
                
                } catch (error) {
                    this.message = {
                        error: ['Something went wrong, please try again later.']
                    }
                    this.processing = false
                }

            }
        }))
    })
</script><?php /**PATH C:\Users\micha\Documents\Projects\eastaccess\resources\views/partials/contact-sections/contact-form.blade.php ENDPATH**/ ?>