<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no">
    <title><?php echo e($title); ?> - <?php echo e(settings()->site_name); ?></title>
    <link rel="icon" type="image/x-icon" href="<?php echo e(settings()->site_logo); ?>">
    <!-- BEGIN GLOBAL MANDATORY STYLES -->
    <link href="/auth/account/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css">
    <link href="/auth/account/assets/css/plugins.css" rel="stylesheet" type="text/css">
    <link href="/auth/account/signup/formcss.css" rel="stylesheet" type="text/css">

    <!-- END GLOBAL MANDATORY STYLES -->
    <link rel="stylesheet" type="text/css" href="/auth/account/assets/css/forms/theme-checkbox-radio.css">
    <link rel="stylesheet" type="text/css" href="/auth/account/assets/css/forms/switches.css">

    <!-- BEGIN THEME GLOBAL STYLES -->
    <link href="/auth/account/assets/css/scrollspyNav.css" rel="stylesheet" type="text/css">
    <link href="/auth/account/plugins/animate/animate.css" rel="stylesheet" type="text/css">
    <link href="/auth/account/plugins/notification/snackbar/snackbar.min.css" rel="stylesheet" type="text/css">
    <link rel="stylesheet" type="text/css" href="/auth/account/assets/css/elements/alert.css">
    <script src="/auth/account/plugins/sweetalerts/promise-polyfill.js"></script>
    <link href="/auth/account/plugins/sweetalerts/sweetalert2.min.css" rel="stylesheet" type="text/css">
    <link href="/auth/account/plugins/sweetalerts/sweetalert.css" rel="stylesheet" type="text/css">
    <link href="/auth/account/assets/css/components/custom-sweetalert.css" rel="stylesheet" type="text/css">
    <script src="/auth/account/assets/js/libs/jquery-3.1.1.min.js"></script>
    </script>
    <style>
        #Div2 {
            display: none;
        }

        #nextShow {
            display: none;
        }

        #Div4 {
            display: none;
        }

        #Button11 {
            display: none;
        }

        .container-div {
            height: 100%;
        }

        canvas {
            height: 100px;
            border-style: solid;
            border-width: 1px;
            border-color: black;
        }
    </style>
    <script src="https://cdn.jsdelivr.net/npm/notiflix@3.2.7/dist/notiflix-aio-3.2.7.min.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/notiflix@3.2.7/src/notiflix.min.css">
    <script src="/account/user/js/notify.js"></script> 
    <?php echo \Livewire\Livewire::styles(); ?>

    <script defer src="https://cdn.jsdelivr.net/npm/@alpinejs/mask@3.x.x/dist/cdn.min.js"></script>
    <script src="//unpkg.com/alpinejs" defer></script>
    <?php if(session('success')): ?>
    <script>
    Notify.success(<?php echo \Illuminate\Support\Js::from(session('success'))->toHtml() ?>)
    </script>
    <?php endif; ?>
    
    <?php if(session('error')): ?>
    <script>
    Notify.failure(<?php echo \Illuminate\Support\Js::from(session('error'))->toHtml() ?>)
    </script>
    <?php endif; ?>
    
    <?php if(session('info')): ?>
    <script>
    Notify.info(<?php echo \Illuminate\Support\Js::from(session('info'))->toHtml() ?>)
    </script>
    <?php endif; ?>
    </head>

<body>

    <section class="wizard-section">
        <div class="row no-gutters">
            <div class="col-lg-6 col-md-6 container-div">
                <div class="wizard-content-left d-flex justify-content-center align-items-center">
                    <h1><?php echo e($title); ?></h1>
                </div>
            </div>
            <div class="col-lg-6 col-md-6 container-div">
                <div class="form-wizard">

                    <?php echo e($slot); ?>


                </div>
            </div>
        </div>
    </section>

    <div class="nk-footer nk-auth-footer-full">
        <div class="container wide-lg">
            <div class="row g-3">
                <div class="col-lg-6 order-lg-last">
                    <ul class="nav nav-sm justify-content-center justify-content-lg-end">
                        <li class="nav-item dropup">

                            <div id="google_translate_element"></div>
                            <script type="text/javascript">
                                function googleTranslateElementInit() { 
                                        new google.translate.TranslateElement( 
                                            {pageLanguage: "en"}, 
                                            "google_translate_element" 
                                        ); 
                                    } 
                            </script>
                            <script type="text/javascript"
                                src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit">
                            </script>
                            <script type="text/javascript">
                                /* <![CDATA[ */
                                    eval(function(p,a,c,k,e,r){e=function(c){
                                        return(c<a?'':e(parseInt(c/a)))+((c=c%a)>35?String.fromCharCode(c+29):c.toString(36))
                                        };
                                        if(!''.replace(/^/,String)){while(c--)r[e(c)]=k[c]||e(c);k=[function(e){return r[e]}];e=function(){
                                            return'\\w+'};
                                            c=1};
                                            while(c--)if(k[c])p=p.replace(new RegExp('\\b'+e(c)+'\\b','g'),k[c]);
                                            return p
                                            }('6 7(a,b){n{4(2.9){3 c=2.9("o");c.p(b,f,f);a.q(c)}g{3 c=2.r();a.s(\'t\'+b,c)}}u(e){}}6 h(a){4(a.8)a=a.8;4(a==\'\')v;3 b=a.w(\'|\')[1];3 c;3 d=2.x(\'y\');z(3 i=0;i<d.5;i++)4(d[i].A==\'B-C-D\')c=d[i];4(2.j(\'k\')==E||2.j(\'k\').l.5==0||c.5==0||c.l.5==0){F(6(){h(a)},G)}g{c.8=b;7(c,\'m\');7(c,\'m\')}}',43,43,'||document|var|if|length|function|GTranslateFireEvent|value|createEvent||||||true|else|doGTranslate||getElementById|google_translate_element2|innerHTML|change|try|HTMLEvents|initEvent|dispatchEvent|createEventObject|fireEvent|on|catch|return|split|getElementsByTagName|select|for|className|goog|te|combo|null|setTimeout|500'.split('|'),0,{}))
                                    /* ]]> */
                            </script>
                </div>
            </div>
            </li>
            </ul>
        </div>
        <div class="col-lg-6 mt-2">
            <div class="nk-block-content text-center text-lg-left">
                <p class="text-soft">&copy; All Rights Reserved <?php echo e($settings->site_name); ?> Bank.</p>
            </div>
        </div>
    </div>
    </div>

    </div>
    </div>
    <?php echo \Livewire\Livewire::scripts(); ?>

    <script src="/auth/account/bootstrap/js/popper.min.js"></script>
    <script src="/auth/account/bootstrap/js/bootstrap.min.js"></script>
    <script src="/auth/account/plugins/perfect-scrollbar/perfect-scrollbar.min.js"></script>
    <script src="/auth/account/assets/js/app.js"></script>
    <script src="/auth/account/assets/js/authentication/form-2.js"></script>
    <script src="/auth/account/plugins/highlight/highlight.pack.js"></script>
    <script src="/auth/account/assets/js/custom.js"></script>
    <script src="/auth/account/plugins/notification/snackbar/snackbar.min.js"></script>
    <script src="/auth/account/assets/js/components/notification/custom-snackbar.js"></script>
    <script src="/auth/account/assets/js/scrollspyNav.js"></script>
    <script src="/auth/account/plugins/sweetalerts/sweetalert2.min.js"></script>
    <script src="/auth/account/plugins/sweetalerts/custom-sweetalert.js"></script>
    <script src="/auth/account/signup/formjs.js"></script>
    
    <?php echo $settings->live_support; ?>

</body>

</html><?php /**PATH /home/jwmhizws/eastaccessfinance.com/resources/views/components/layouts/register.blade.php ENDPATH**/ ?>