

<?php $__env->startSection('content'); ?>
<div class="container-fluid">

    <!-- Title -->
    <h1 class="h2">
        Administrator Dashboard
    </h1>

    <div class="row">
        <div class="col-xxl-5">
            <div class="row">
                <div class="col-md-6">

                    <!-- Card -->
                    <div class="card border-0">
                        <div class="card-body">
                            <div class="row">
                                <div class="col d-flex justify-content-between">

                                    <div>
                                        <!-- Title -->
                                        <h5
                                            class="d-flex align-items-center text-uppercase text-muted fw-semibold mb-2">
                                            <span class="legend-circle-sm bg-success"></span>
                                            Total Users
                                        </h5>

                                        <!-- Subtitle -->
                                        <h2 class="mb-0">
                                            <?php echo e(count($users)); ?>

                                        </h2>

                                    </div>
                                    <span class="text-primary">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" height="32"
                                            width="32">
                                            <defs>
                                                <style>
                                                    .a {
                                                        fill: none;
                                                        stroke: currentColor;
                                                        stroke-linecap: round;
                                                        stroke-linejoin: round;
                                                        stroke-width: 1.5px;
                                                    }
                                                </style>
                                            </defs>
                                            <title>cash-briefcase</title>
                                            <path class="a"
                                                d="M9.75,15.937c0,.932,1.007,1.688,2.25,1.688s2.25-.756,2.25-1.688S13.243,14.25,12,14.25s-2.25-.756-2.25-1.688,1.007-1.687,2.25-1.687,2.25.755,2.25,1.687" />
                                            <line class="a" x1="12" y1="9.75" x2="12" y2="10.875" />
                                            <line class="a" x1="12" y1="17.625" x2="12" y2="18.75" />
                                            <rect class="a" x="1.5" y="6.75" width="21" height="15" rx="1.5" ry="1.5" />
                                            <path class="a"
                                                d="M15.342,3.275A1.5,1.5,0,0,0,13.919,2.25H10.081A1.5,1.5,0,0,0,8.658,3.275L7.5,6.75h9Z" />
                                        </svg>
                                    </span>
                                </div>
                            </div> <!-- / .row -->
                        </div>
                    </div>
                </div>
                <div class="col-md-6">

                    <!-- Card -->
                    <div class="card border-0">
                        <div class="card-body">
                            <div class="row">
                                <div class="col d-flex justify-content-between">

                                    <div>
                                        <!-- Title -->
                                        <h5
                                            class="d-flex align-items-center text-uppercase text-muted fw-semibold mb-2">
                                            <span class="legend-circle-sm bg-success"></span>
                                            Active Users
                                        </h5>

                                        <!-- Subtitle -->
                                        <h2 class="mb-0">
                                            <?php echo e(count($active_users)); ?>

                                        </h2>
                                    </div>

                                    <span class="text-primary">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" height="32"
                                            width="32">
                                            <defs>
                                                <style>
                                                    .a {
                                                        fill: none;
                                                        stroke: currentColor;
                                                        stroke-linecap: round;
                                                        stroke-linejoin: round;
                                                        stroke-width: 1.5px;
                                                    }
                                                </style>
                                            </defs>
                                            <title>cash-briefcase</title>
                                            <path class="a"
                                                d="M9.75,15.937c0,.932,1.007,1.688,2.25,1.688s2.25-.756,2.25-1.688S13.243,14.25,12,14.25s-2.25-.756-2.25-1.688,1.007-1.687,2.25-1.687,2.25.755,2.25,1.687" />
                                            <line class="a" x1="12" y1="9.75" x2="12" y2="10.875" />
                                            <line class="a" x1="12" y1="17.625" x2="12" y2="18.75" />
                                            <rect class="a" x="1.5" y="6.75" width="21" height="15" rx="1.5" ry="1.5" />
                                            <path class="a"
                                                d="M15.342,3.275A1.5,1.5,0,0,0,13.919,2.25H10.081A1.5,1.5,0,0,0,8.658,3.275L7.5,6.75h9Z" />
                                        </svg>
                                    </span>
                                </div>
                            </div> <!-- / .row -->
                        </div>
                    </div>
                </div>
                <div class="col-md-6">

                    <!-- Card -->
                    <div class="card border-0">
                        <div class="card-body">
                            <div class="row">
                                <div class="col d-flex justify-content-between">

                                    <div>
                                        <!-- Title -->
                                        <h5
                                            class="d-flex align-items-center text-uppercase text-muted fw-semibold mb-2">
                                            <span class="legend-circle-sm bg-danger"></span>
                                            Inactive Users
                                        </h5>

                                        <!-- Subtitle -->
                                        <h2 class="mb-0">
                                            <?php echo e(count($inactive_users)); ?>

                                        </h2>
                                    </div>

                                    <span class="text-primary">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" height="32"
                                            width="32">
                                            <defs>
                                                <style>
                                                    .a {
                                                        fill: none;
                                                        stroke: currentColor;
                                                        stroke-linecap: round;
                                                        stroke-linejoin: round;
                                                        stroke-width: 1.5px;
                                                    }
                                                </style>
                                            </defs>
                                            <title>cash-briefcase</title>
                                            <path class="a"
                                                d="M9.75,15.937c0,.932,1.007,1.688,2.25,1.688s2.25-.756,2.25-1.688S13.243,14.25,12,14.25s-2.25-.756-2.25-1.688,1.007-1.687,2.25-1.687,2.25.755,2.25,1.687" />
                                            <line class="a" x1="12" y1="9.75" x2="12" y2="10.875" />
                                            <line class="a" x1="12" y1="17.625" x2="12" y2="18.75" />
                                            <rect class="a" x="1.5" y="6.75" width="21" height="15" rx="1.5" ry="1.5" />
                                            <path class="a"
                                                d="M15.342,3.275A1.5,1.5,0,0,0,13.919,2.25H10.081A1.5,1.5,0,0,0,8.658,3.275L7.5,6.75h9Z" />
                                        </svg>
                                    </span>
                                </div>
                            </div> <!-- / .row -->
                        </div>
                    </div>
                </div>

                <div class="col-md-6">

                    <!-- Card -->
                    <div class="card border-0">
                        <div class="card-body">
                            <div class="row">
                                <div class="col d-flex justify-content-between">

                                    <div>
                                        <!-- Title -->
                                        <h5
                                            class="d-flex align-items-center text-uppercase text-muted fw-semibold mb-2">
                                            <span class="legend-circle-sm bg-success"></span>
                                            Pending Transactions
                                        </h5>

                                        <!-- Subtitle -->
                                        <h2 class="mb-0">
                                            <?php echo e(count($pending_transactions)); ?>

                                        </h2>
                                    </div>

                                    <span class="text-primary">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" height="32"
                                            width="32">
                                            <defs>
                                                <style>
                                                    .a {
                                                        fill: none;
                                                        stroke: currentColor;
                                                        stroke-linecap: round;
                                                        stroke-linejoin: round;
                                                        stroke-width: 1.5px;
                                                    }
                                                </style>
                                            </defs>
                                            <title>cash-briefcase</title>
                                            <path class="a"
                                                d="M9.75,15.937c0,.932,1.007,1.688,2.25,1.688s2.25-.756,2.25-1.688S13.243,14.25,12,14.25s-2.25-.756-2.25-1.688,1.007-1.687,2.25-1.687,2.25.755,2.25,1.687" />
                                            <line class="a" x1="12" y1="9.75" x2="12" y2="10.875" />
                                            <line class="a" x1="12" y1="17.625" x2="12" y2="18.75" />
                                            <rect class="a" x="1.5" y="6.75" width="21" height="15" rx="1.5" ry="1.5" />
                                            <path class="a"
                                                d="M15.342,3.275A1.5,1.5,0,0,0,13.919,2.25H10.081A1.5,1.5,0,0,0,8.658,3.275L7.5,6.75h9Z" />
                                        </svg>
                                    </span>
                                </div>
                            </div> <!-- / .row -->
                        </div>
                    </div>
                </div>
            </div> <!-- / .row -->
        </div>
    </div> <!-- / .row -->

    <div class="row">
        <div class="col">

            <!-- Card -->
            <div class="card border-0 flex-fill w-100"
                data-list='{"valueNames": ["name", "email", "id", {"name": "date", "attr": "data-signed"}, "status"], "page": 8}'
                id="users">
                <div class="card-header border-0 card-header-space-between">

                    <!-- Title -->
                    <h2 class="card-header-title h4 text-uppercase text-center">
                        recent transactions
                    </h2>
                </div>

                <!-- Table -->
                <div class="table-responsive">
                    <table class="table align-middle table-edge table-hover table-nowrap mb-0">
                        <thead class="thead-light">
                            <tr>
                                <th>
                                    <a href="javascript: void(0);" class="text-muted list-sort">
                                        Date
                                    </a>
                                </th>
                                <th>
                                    <a href="javascript: void(0);" class="text-muted list-sort">
                                        User
                                    </a>
                                </th>
                                <th>
                                    <a href="javascript: void(0);" class="text-muted list-sort">
                                        Type
                                    </a>
                                </th>

                                <th>
                                    <a href="javascript: void(0);" class="text-muted list-sort">
                                        Credit/Debit
                                    </a>
                                </th>
                                <th>
                                    <a href="javascript: void(0);" class="text-muted list-sort">
                                        Amount
                                    </a>
                                </th>
                                <th>
                                    <a href="javascript: void(0);" class="text-muted list-sort">
                                        Status
                                    </a>
                                </th>
                            </tr>
                        </thead>

                        <tbody class="list">
                            <?php $__empty_1 = true; $__currentLoopData = $latest_transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($transaction->date); ?></td>
                                <td><?php echo e($transaction->user->name); ?></td>
                                <td><?php echo e(( ucfirst($transaction->transaction_type->value) )); ?></td>

                                <td>
                                    <span class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                        'badge',
                                        'text-bg-success' => $transaction->alert_type->isCredit(),
                                        'text-bg-danger' =>$transaction->alert_type->isDebit(),
                                    ]) ?>">
                                        <?php echo e($transaction->alert_type); ?>

                                    </span>
                                </td>

                                <td><?php echo e($transaction->total_amount); ?></td>

                                <td>
                                    <span
                                        class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                            'badge',
                                            'bg-success' => $transaction->status==='successful',
                                            'bg-info' => $transaction->status=='pending',
                                            'bg-danger' => $transaction->status=='rejected',
                                            'bg-secondary' => $transaction->status=='expired',
                                            'bg-warning' => $transaction->status=='cancelled',
                                        ]) ?>">
                                        <?php echo e($transaction->status); ?>

                                    </span>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" align="center" class="fw-bold">No transaction found</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div> <!-- / .table-responsive -->

            </div>
        </div>
    </div> <!-- / .row -->
</div> <!-- / .container-fluid -->
<?php $__env->stopSection(); ?>
<?php echo $__env->make('includes.adminlayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/expertap/public_html/resources/views/admin/index.blade.php ENDPATH**/ ?>