<!-- NAVIGATION -->
<nav id="mainNavbar" class="navbar navbar-vertical navbar-expand-lg scrollbar bg-dark navbar-dark">

    <!-- Theme configuration (navbar) -->
    <script>
        let navigationColor = localStorage.getItem('navigationColor'),
                        navbar = document.getElementById('mainNavbar');
                
                    if(navigationColor != null && navbar != null) {
                        if(navigationColor == 'inverted') {
                            navbar.classList.add('bg-dark', 'navbar-dark');
                            navbar.classList.remove('bg-white', 'navbar-light');
                        } else {
                            navbar.classList.add('bg-white', 'navbar-light');
                            navbar.classList.remove('bg-dark', 'navbar-dark');
                        }
                    }
    </script>
    <div class="container-fluid">

        <!-- Brand -->
        <a class="navbar-brand" href="/">
            <img src="<?php echo e(settings()->alt_site_logo); ?>" class="navbar-brand-img logo-dark logo-large" alt="..." width="125">
        </a>
        <!-- Navbar toggler -->
        <a href="javascript: void(0);" class="navbar-toggler" data-bs-toggle="collapse"
            data-bs-target="#sidenavCollapse" aria-controls="sidenavCollapse" aria-expanded="false"
            aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </a>

        <!-- Collapse -->
        <div class="collapse navbar-collapse" id="sidenavCollapse">

            <!-- Navigation -->
            <ul class="navbar-nav mb-lg-7">
                <li class="nav-item">
                    <a class="nav-link <?php echo e(route('admin.dashboard')==url()->current() ? 'active':''); ?>"
                        href="<?php echo e(route('admin.dashboard')); ?>">
                        <span class="material-icons pb-1">home</span>&nbsp;&nbsp;
                        <span>Dashboard</span>
                    </a>
                </li>
                <li class="nav-item dropdown">
                    <a class="nav-link <?php echo e(route('admin.allusers')==url()->current() ? 'active':''); ?> <?php echo e(route('admin.user_signup')==url()->current() ? 'active':''); ?>"
                        href="#authenticationEmailVerificationCollapse" data-bs-toggle="collapse" role="button"
                        aria-expanded="false" aria-controls="authenticationEmailVerificationCollapse">
                        <span class="material-icons pb-1">supervised_user_circle</span>&nbsp;&nbsp; Users
                    </a>
                    <div class="collapse " id="authenticationEmailVerificationCollapse">
                        <ul class="nav flex-column active">
                            <li class="nav-item">
                                <a href="<?php echo e(route('admin.allusers')); ?>" class="nav-link ">
                                    All Users
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('admin.user_signup')); ?>" class="nav-link ">
                                    Create New User
                                </a>
                            </li>
                        </ul>
                    </div>
                </li>

                <li class="nav-item">
                    <a class="nav-link <?php echo e(route('admin.local_transfer')==url()->current() ? 'active':''); ?>"
                        href="<?php echo e(route('admin.local_transfer')); ?>">
                        <span class="material-icons pb-1">account_balance</span>&nbsp;&nbsp;
                        <span>Credit/Debit Users</span>
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link <?php echo e(route('admin.all_requests')==url()->current() ? 'active':''); ?>"
                        href="<?php echo e(route('admin.all_requests')); ?>">
                        <span class="material-icons pb-1">trending_up</span>&nbsp;&nbsp;
                        <span>Pending Transfers</span><span class="badge text-bg-light"></span>
                    </a>
                </li>


                <li class="nav-item">
                    <a class="nav-link <?php echo e(route('admin.all_transactions')==url()->current() ? 'active':''); ?>"
                        href="<?php echo e(route('admin.all_transactions')); ?>">
                        <span class="material-icons pb-1">bar_chart</span>&nbsp;&nbsp;
                        <span>Transaction Log</span>
                    </a>
                </li>
    
                <li class="nav-item">
                    <a class="nav-link <?php echo e(route('admin.cards')==url()->current() ? 'active':''); ?>"
                        href="<?php echo e(route('admin.cards')); ?>">
                        <span class="material-icons pb-1">credit_card</span>&nbsp;&nbsp; Cards
                    </a>
                </li>

                <li class="nav-item dropdown">
                    <a class="nav-link <?php echo e(route('settings.config')===url()->current() ? 'active':''); ?><?php echo e(route('admin.site_settings')===url()->current() ? 'active':''); ?>"
                        href="#settingsDrop" data-bs-toggle="collapse" role="button" aria-expanded="false"
                        aria-controls="settingsDrop">
                        <span class="material-icons pb-1">settings</span>&nbsp;&nbsp; Settings
                    </a>
                    <div class="collapse " id="settingsDrop">
                        <ul class="nav flex-column">
                            <li class="nav-item">
                                <a href="<?php echo e(route('admin.site_settings')); ?>" class="nav-link ">
                                    Site Settings
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('settings.config')); ?>" class="nav-link ">
                                    Configurations
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('settings.deposit-methods')); ?>" class="nav-link ">
                                    Deposit Methods
                                </a>
                            </li>
                        </ul>
                    </div>
                </li>

                <li class="nav-item">
                    <a 
                        class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                            'nav-link',
                            'active' => request()->routeIs('admin.deposits.*')
                        ]) ?>"
                    class="nav-link"
                        href="<?php echo e(route('admin.deposits.all')); ?>">
                        <span class="material-icons pb-1">account_balance_wallet</span>&nbsp;&nbsp;
                        <span>Deposits</span>
                    </a>
                </li>

                <li class="nav-item">
                    <a 
                        class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                            'nav-link',
                            'active' => request()->routeIs('admin.loans')
                        ]) ?>"
                    class="nav-link"
                        href="<?php echo e(route('admin.loans')); ?>">
                        <span class="material-icons pb-1">request_quote</span>&nbsp;&nbsp;
                        <span>Loan</span>
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link <?php echo e(route('admin.profile')==url()->current() ? 'active':''); ?>"
                        href="<?php echo e(route('admin.profile')); ?>">
                        <span class="material-icons pb-1">account_circle</span>&nbsp;&nbsp;
                        <span>Profile</span>
                    </a>
                </li>
                <li class="nav-item dropdown">
                    <a class="nav-link <?php echo e(route('login.history') == url()->current() ? 'active' : ''); ?><?php echo e(route('transaction.generate') == url()->current() ? 'active' : ''); ?>"
                        href="#generateTransaction" data-bs-toggle="collapse" role="button" aria-expanded="false"
                        aria-controls="generateTransaction">
                        <span class="material-icons pb-1">format_align_justify</span>&nbsp;&nbsp; <small
                            style="font-size: 12px">Generate Transaction</small>
                    </a>
                    <div class="collapse " id="generateTransaction">
                        <ul class="nav flex-column">
                            <li class="nav-item">
                                <a href="<?php echo e(route('transaction.generate')); ?>" class="nav-link ">
                                    Generate Transaction
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('login.history')); ?>" class="nav-link ">
                                    Login History
                                </a>
                            </li>
                        </ul>
                    </div>
                </li>
                <div class="text-primary">
                    <li class="nav-item">
                        <a class="nav-link " href="<?php echo e(route('admin.logout')); ?>">
                            <span class="material-icons pb-1 text-primary">logout</span>&nbsp;&nbsp;
                            <span class="text-primary">Logout</span>
                        </a>
                    </li>
                </div>
            </ul>
            <!-- End of Navigation -->

        </div>
        <!-- End of Collapse -->
    </div>
</nav>
<!-- MAIN CONTENT -->
<main>

    <!-- HEADER -->
    <header class="container-fluid d-flex py-6 mb-4">
        <!-- Top buttons -->
        <div class="d-flex align-items-center ms-auto me-n1 me-lg-n2">

            <!-- Dropdown -->
            <div class="dropdown" id="themeSwitcher">
                <a href="javascript: void(0);"
                    class="dropdown-toggle no-arrow d-flex align-items-center justify-content-center bg-white rounded-circle shadow-sm mx-1 mx-lg-2 w-40px h-40px link-secondary"
                    role="button" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false"
                    data-bs-offset="0,10">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" height="18" width="18">
                        <g>
                            <path
                                d="M12,4.64A7.36,7.36,0,1,0,19.36,12,7.37,7.37,0,0,0,12,4.64Zm0,12.72A5.36,5.36,0,1,1,17.36,12,5.37,5.37,0,0,1,12,17.36Z"
                                style="fill: currentColor" />
                            <path d="M12,3.47a1,1,0,0,0,1-1V1a1,1,0,0,0-2,0V2.47A1,1,0,0,0,12,3.47Z"
                                style="fill: currentColor" />
                            <path d="M4.55,6a1,1,0,0,0,.71.29A1,1,0,0,0,6,6,1,1,0,0,0,6,4.55l-1-1A1,1,0,0,0,3.51,4.93Z"
                                style="fill: currentColor" />
                            <path d="M2.47,11H1a1,1,0,0,0,0,2H2.47a1,1,0,1,0,0-2Z" style="fill: currentColor" />
                            <path
                                d="M4.55,18l-1,1a1,1,0,0,0,0,1.42,1,1,0,0,0,.71.29,1,1,0,0,0,.71-.29l1-1A1,1,0,0,0,4.55,18Z"
                                style="fill: currentColor" />
                            <path d="M12,20.53a1,1,0,0,0-1,1V23a1,1,0,0,0,2,0V21.53A1,1,0,0,0,12,20.53Z"
                                style="fill: currentColor" />
                            <path
                                d="M19.45,18A1,1,0,0,0,18,19.45l1,1a1,1,0,0,0,.71.29,1,1,0,0,0,.71-.29,1,1,0,0,0,0-1.42Z"
                                style="fill: currentColor" />
                            <path d="M23,11H21.53a1,1,0,0,0,0,2H23a1,1,0,0,0,0-2Z" style="fill: currentColor" />
                            <path
                                d="M18.74,6.26A1,1,0,0,0,19.45,6l1-1a1,1,0,1,0-1.42-1.42l-1,1A1,1,0,0,0,18,6,1,1,0,0,0,18.74,6.26Z"
                                style="fill: currentColor" />
                        </g>
                    </svg>
                </a>

                <ul class="dropdown-menu dropdown-menu-end">
                    <li>
                        <button type="button" class="dropdown-item active" data-theme-value="light">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="me-2" height="18"
                                width="18">
                                <g>
                                    <path
                                        d="M12,4.64A7.36,7.36,0,1,0,19.36,12,7.37,7.37,0,0,0,12,4.64Zm0,12.72A5.36,5.36,0,1,1,17.36,12,5.37,5.37,0,0,1,12,17.36Z"
                                        style="fill: currentColor" />
                                    <path d="M12,3.47a1,1,0,0,0,1-1V1a1,1,0,0,0-2,0V2.47A1,1,0,0,0,12,3.47Z"
                                        style="fill: currentColor" />
                                    <path
                                        d="M4.55,6a1,1,0,0,0,.71.29A1,1,0,0,0,6,6,1,1,0,0,0,6,4.55l-1-1A1,1,0,0,0,3.51,4.93Z"
                                        style="fill: currentColor" />
                                    <path d="M2.47,11H1a1,1,0,0,0,0,2H2.47a1,1,0,1,0,0-2Z" style="fill: currentColor" />
                                    <path
                                        d="M4.55,18l-1,1a1,1,0,0,0,0,1.42,1,1,0,0,0,.71.29,1,1,0,0,0,.71-.29l1-1A1,1,0,0,0,4.55,18Z"
                                        style="fill: currentColor" />
                                    <path d="M12,20.53a1,1,0,0,0-1,1V23a1,1,0,0,0,2,0V21.53A1,1,0,0,0,12,20.53Z"
                                        style="fill: currentColor" />
                                    <path
                                        d="M19.45,18A1,1,0,0,0,18,19.45l1,1a1,1,0,0,0,.71.29,1,1,0,0,0,.71-.29,1,1,0,0,0,0-1.42Z"
                                        style="fill: currentColor" />
                                    <path d="M23,11H21.53a1,1,0,0,0,0,2H23a1,1,0,0,0,0-2Z" style="fill: currentColor" />
                                    <path
                                        d="M18.74,6.26A1,1,0,0,0,19.45,6l1-1a1,1,0,1,0-1.42-1.42l-1,1A1,1,0,0,0,18,6,1,1,0,0,0,18.74,6.26Z"
                                        style="fill: currentColor" />
                                </g>
                            </svg>
                            Light mode
                        </button>
                    </li>
                    <li>
                        <button type="button" class="dropdown-item" data-theme-value="dark">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="me-2" height="18"
                                width="18">
                                <path
                                    d="M19.57,23.34a1,1,0,0,0,0-1.9,9.94,9.94,0,0,1,0-18.88,1,1,0,0,0,.68-.94,1,1,0,0,0-.68-.95A11.58,11.58,0,0,0,8.88,2.18,12.33,12.33,0,0,0,3.75,12a12.31,12.31,0,0,0,5.11,9.79A11.49,11.49,0,0,0,15.61,24,12.55,12.55,0,0,0,19.57,23.34ZM10,20.17A10.29,10.29,0,0,1,5.75,12a10.32,10.32,0,0,1,4.3-8.19A9.34,9.34,0,0,1,15.59,2a.17.17,0,0,1,.17.13.18.18,0,0,1-.07.2,11.94,11.94,0,0,0-.18,19.21.25.25,0,0,1-.16.45A9.5,9.5,0,0,1,10,20.17Z"
                                    style="fill: currentColor" />
                            </svg>
                            Dark mode
                        </button>
                    </li>
                    <li>
                        <button type="button" class="dropdown-item" data-theme-value="auto">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="me-2" height="18"
                                width="18">
                                <path
                                    d="M24,12a1,1,0,0,0-1-1H19.09a.51.51,0,0,1-.49-.4,6.83,6.83,0,0,0-.94-2.28.5.5,0,0,1,.06-.63l2.77-2.76a1,1,0,1,0-1.42-1.42L16.31,6.28a.5.5,0,0,1-.63.06A6.83,6.83,0,0,0,13.4,5.4a.5.5,0,0,1-.4-.49V1a1,1,0,0,0-2,0V4.91a.51.51,0,0,1-.4.49,6.83,6.83,0,0,0-2.28.94.5.5,0,0,1-.63-.06L4.93,3.51A1,1,0,0,0,3.51,4.93L6.28,7.69a.5.5,0,0,1,.06.63A6.83,6.83,0,0,0,5.4,10.6a.5.5,0,0,1-.49.4H1a1,1,0,0,0,0,2H4.91a.51.51,0,0,1,.49.4,6.83,6.83,0,0,0,.94,2.28.5.5,0,0,1-.06.63L3.51,19.07a1,1,0,1,0,1.42,1.42l2.76-2.77a.5.5,0,0,1,.63-.06,6.83,6.83,0,0,0,2.28.94.5.5,0,0,1,.4.49V23a1,1,0,0,0,2,0V19.09a.51.51,0,0,1,.4-.49,6.83,6.83,0,0,0,2.28-.94.5.5,0,0,1,.63.06l2.76,2.77a1,1,0,1,0,1.42-1.42l-2.77-2.76a.5.5,0,0,1-.06-.63,6.83,6.83,0,0,0,.94-2.28.5.5,0,0,1,.49-.4H23A1,1,0,0,0,24,12Zm-8.74,2.5A5.76,5.76,0,0,1,9.5,8.74a5.66,5.66,0,0,1,.16-1.31A.49.49,0,0,1,10,7.07a5.36,5.36,0,0,1,1.8-.31,5.47,5.47,0,0,1,5.46,5.46,5.36,5.36,0,0,1-.31,1.8.49.49,0,0,1-.35.32A5.53,5.53,0,0,1,15.26,14.5Z"
                                    style="fill: currentColor" />
                            </svg>
                            Auto
                        </button>
                    </li>
                </ul>
            </div>

            <!-- Separator -->
            <div class="vr bg-gray-700 mx-2 mx-lg-3"></div>

            <!-- Button -->
            <a class="d-flex align-items-center justify-content-center bg-white rounded-circle shadow-sm mx-1 mx-lg-2 w-40px h-40px link-secondary"
                data-bs-toggle="offcanvas" href="#offcanvasCustomize" role="button" aria-controls="offcanvasCustomize">
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" height="18" width="18">
                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                        d="M7.77069 9.50524C7.60364 9.43126 7.45391 9.32316 7.33112 9.18788L6.70112 8.48788C6.5212 8.28484 6.28225 8.14317 6.01778 8.08272C5.7533 8.02228 5.47654 8.0461 5.22627 8.15083C4.97601 8.25557 4.76478 8.43598 4.62219 8.66678C4.4796 8.89758 4.41279 9.16721 4.43112 9.43788V10.3679C4.44125 10.5505 4.41275 10.7331 4.34748 10.9039C4.28221 11.0747 4.18165 11.2298 4.05235 11.3591C3.92306 11.4884 3.76795 11.589 3.59714 11.6542C3.42634 11.7195 3.24369 11.748 3.06112 11.7379L2.12112 11.6879C1.85153 11.6753 1.58463 11.7463 1.35691 11.8911C1.12919 12.036 0.951762 12.2476 0.848892 12.4971C0.746023 12.7467 0.72273 13.0219 0.782196 13.2851C0.841663 13.5484 0.980987 13.7868 1.18112 13.9679L1.88112 14.5879C2.01927 14.7148 2.129 14.8695 2.20311 15.0419C2.27722 15.2142 2.31403 15.4003 2.31112 15.5879C2.31532 15.7757 2.2791 15.9621 2.2049 16.1347C2.13071 16.3072 2.02029 16.4618 1.88112 16.5879L1.18112 17.2179C0.981519 17.3992 0.842717 17.6376 0.783657 17.9007C0.724597 18.1638 0.748157 18.4387 0.85112 18.6879C0.954125 18.9362 1.13156 19.1464 1.359 19.2897C1.58644 19.433 1.8527 19.5022 2.12112 19.4879H3.06112C3.24369 19.4778 3.42634 19.5063 3.59714 19.5715C3.76795 19.6368 3.92306 19.7374 4.05235 19.8666C4.18165 19.9959 4.28221 20.1511 4.34748 20.3219C4.41275 20.4927 4.44125 20.6753 4.43112 20.8579V21.7879C4.4151 22.0577 4.48357 22.3258 4.62702 22.5549C4.77046 22.784 4.98174 22.9626 5.23147 23.066C5.48119 23.1694 5.75693 23.1925 6.02034 23.1318C6.28374 23.0712 6.5217 22.93 6.70112 22.7279L7.33112 22.0379C7.45391 21.9026 7.60364 21.7945 7.77069 21.7205C7.93775 21.6466 8.11842 21.6083 8.30112 21.6083C8.48382 21.6083 8.6645 21.6466 8.83155 21.7205C8.9986 21.7945 9.14833 21.9026 9.27112 22.0379L9.90112 22.7279C10.0805 22.93 10.3185 23.0712 10.5819 23.1318C10.8453 23.1925 11.1211 23.1694 11.3708 23.066C11.6205 22.9626 11.8318 22.784 11.9752 22.5549C12.1187 22.3258 12.1871 22.0577 12.1711 21.7879V20.8579C12.161 20.6753 12.1895 20.4927 12.2548 20.3219C12.32 20.1511 12.4206 19.9959 12.5499 19.8666C12.6792 19.7374 12.8343 19.6368 13.0051 19.5715C13.1759 19.5063 13.3586 19.4778 13.5411 19.4879H14.4811C14.7495 19.5022 15.0158 19.433 15.2432 19.2897C15.4707 19.1464 15.6481 18.9362 15.7511 18.6879C15.8541 18.4387 15.8776 18.1638 15.8186 17.9007C15.7595 17.6376 15.6207 17.3992 15.4211 17.2179L14.7211 16.5879C14.582 16.4618 14.4715 16.3072 14.3973 16.1347C14.3231 15.9621 14.2869 15.7757 14.2911 15.5879C14.2882 15.4003 14.325 15.2142 14.3991 15.0419C14.4732 14.8695 14.583 14.7148 14.7211 14.5879L15.4211 13.9679C15.6213 13.7868 15.7606 13.5484 15.82 13.2851C15.8795 13.0219 15.8562 12.7467 15.7533 12.4971C15.6505 12.2476 15.4731 12.036 15.2453 11.8911C15.0176 11.7463 14.7507 11.6753 14.4811 11.6879L13.5411 11.7379C13.3586 11.748 13.1759 11.7195 13.0051 11.6542C12.8343 11.589 12.6792 11.4884 12.5499 11.3591C12.4206 11.2298 12.32 11.0747 12.2548 10.9039C12.1895 10.7331 12.161 10.5505 12.1711 10.3679V9.43788C12.1895 9.16721 12.1226 8.89758 11.98 8.66678C11.8375 8.43598 11.6262 8.25557 11.376 8.15083C11.1257 8.0461 10.8489 8.02228 10.5845 8.08272C10.32 8.14317 10.081 8.28484 9.90112 8.48788L9.27112 9.18788C9.14833 9.32316 8.9986 9.43126 8.83155 9.50524C8.6645 9.57922 8.48382 9.61743 8.30112 9.61743C8.11842 9.61743 7.93775 9.57922 7.77069 9.50524Z" />
                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                        d="M8.30114 17.4379C9.33944 17.4379 10.1811 16.5962 10.1811 15.5579C10.1811 14.5196 9.33944 13.6779 8.30114 13.6779C7.26285 13.6779 6.42114 14.5196 6.42114 15.5579C6.42114 16.5962 7.26285 17.4379 8.30114 17.4379Z" />
                    <path stroke="currentColor" stroke-width="1.5"
                        d="M18.1565 6.23828C17.8804 6.23828 17.6565 6.01442 17.6565 5.73828C17.6565 5.46214 17.8804 5.23828 18.1565 5.23828" />
                    <path stroke="currentColor" stroke-width="1.5"
                        d="M18.1565 6.23828C18.4326 6.23828 18.6565 6.01442 18.6565 5.73828C18.6565 5.46214 18.4326 5.23828 18.1565 5.23828" />
                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                        d="M16.1347 1.83506C16.1409 1.62338 16.2152 1.41935 16.3466 1.25325C16.478 1.08716 16.6594 0.967851 16.8639 0.91304C17.0685 0.85823 17.2853 0.870838 17.4821 0.948992C17.6789 1.02715 17.8453 1.16668 17.9565 1.34689L18.551 2.30113C18.6493 2.45959 18.8042 2.57479 18.9842 2.62343C19.1643 2.67207 19.3561 2.65052 19.5209 2.56313L20.508 2.03729C20.6955 1.93854 20.9096 1.90249 21.1191 1.93443C21.3285 1.96638 21.5222 2.06463 21.6716 2.21476C21.8211 2.3649 21.9185 2.559 21.9495 2.76857C21.9805 2.97814 21.9435 3.19214 21.8439 3.37912L21.3171 4.37019C21.2295 4.53545 21.2077 4.72774 21.2561 4.90841C21.3045 5.08907 21.4195 5.24471 21.578 5.34404L22.5273 5.9411C22.7071 6.05324 22.8461 6.22006 22.924 6.41706C23.002 6.61406 23.0147 6.83085 22.9603 7.03561C22.9059 7.24036 22.7873 7.42229 22.6219 7.55467C22.4565 7.68705 22.253 7.7629 22.0413 7.7711L20.9235 7.80929C20.7371 7.816 20.5602 7.89324 20.4286 8.02539C20.297 8.15754 20.2205 8.33473 20.2145 8.52115L20.179 9.64113C20.1727 9.85281 20.0984 10.0568 19.967 10.2229C19.8357 10.389 19.6542 10.5083 19.4497 10.5631C19.2451 10.618 19.0284 10.6053 18.8315 10.5272C18.6347 10.449 18.4683 10.3095 18.3571 10.1293L17.762 9.17525C17.6638 9.0168 17.509 8.90157 17.3291 8.85289C17.1492 8.80422 16.9575 8.82572 16.7928 8.91305L15.8049 9.43908C15.6175 9.53784 15.4033 9.57389 15.1939 9.54194C14.9844 9.51 14.7908 9.41175 14.6413 9.26161C14.4918 9.11148 14.3944 8.91737 14.3634 8.7078C14.3324 8.49823 14.3694 8.28424 14.469 8.09725L14.9933 7.10534C15.0809 6.94007 15.1027 6.74778 15.0543 6.56712C15.0059 6.38645 14.8909 6.23081 14.7324 6.13148L13.7831 5.53748C13.6034 5.42533 13.4643 5.25851 13.3864 5.06151C13.3085 4.86452 13.2958 4.64772 13.3501 4.44296C13.4045 4.23821 13.5231 4.05628 13.6885 3.92391C13.8539 3.79153 14.0574 3.71567 14.2691 3.70748L15.3877 3.66909C15.5739 3.66238 15.7507 3.58515 15.8822 3.45302C16.0137 3.32089 16.0901 3.14374 16.0959 2.95743L16.1347 1.83506Z" />
                </svg>
            </a>

            <!-- Custmization offcanvas -->
            <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasCustomize"
                aria-labelledby="offcanvasCustomizeTitle">
                <div class="offcanvas-body pt-7 pb-5 position-relative">

                    <button type="button" class="btn-close position-absolute top-0 end-0 mt-5 me-5"
                        data-bs-dismiss="offcanvas" aria-label="Close"></button>

                    <div class="text-center">
                        <img src="https://d33wubrfki0l68.cloudfront.net/0e108d71de2aec22aae71d891ecabd0ec28dc2bb/8484b/assets/images/illustrations/customization-illustration.svg"
                            alt="..." class="img-fluid w-50 mb-5" width="170" height="170">
                        <h3 class="mb-2" id="offcanvasCustomizeTitle">Personalize your Dashboard</h3>
                        <p class="mb-0">Set preferences that will be cookied for your live preview demonstration</p>
                    </div>

                    <hr />

                    <h4 class="mb-0">Color Scheme</h4>
                    <p class="text-secondary fs-5 mb-4">Overall light or dark presentation.</p>
                    <div class="btn-group w-100 mb-7" role="group" aria-label="Light/dark switcher">
                        <input type="radio" class="btn-check" name="theme" id="lightMode" value="light"
                            data-theme-control="theme">
                        <label
                            class="btn btn-outline-primary px-3 w-100 d-flex align-items-center justify-content-center"
                            for="lightMode">
                            <span class="material-icons">
                                sunny
                            </span>
                            Light
                        </label>

                        <input type="radio" class="btn-check" name="theme" id="darkMode" value="dark"
                            data-theme-control="theme">
                        <label
                            class="btn btn-outline-primary px-3 w-100 d-flex align-items-center justify-content-center"
                            for="darkMode">
                            <span class="material-icons">
                                bedtime
                            </span>
                            Dark
                        </label>

                        <input type="radio" class="btn-check" name="theme" id="autoMode" value="auto"
                            data-theme-control="theme">
                        <label
                            class="btn btn-outline-primary px-3 w-100 d-flex align-items-center justify-content-center"
                            for="autoMode">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="me-2" height="18"
                                width="18">
                                <path
                                    d="M24,12a1,1,0,0,0-1-1H19.09a.51.51,0,0,1-.49-.4,6.83,6.83,0,0,0-.94-2.28.5.5,0,0,1,.06-.63l2.77-2.76a1,1,0,1,0-1.42-1.42L16.31,6.28a.5.5,0,0,1-.63.06A6.83,6.83,0,0,0,13.4,5.4a.5.5,0,0,1-.4-.49V1a1,1,0,0,0-2,0V4.91a.51.51,0,0,1-.4.49,6.83,6.83,0,0,0-2.28.94.5.5,0,0,1-.63-.06L4.93,3.51A1,1,0,0,0,3.51,4.93L6.28,7.69a.5.5,0,0,1,.06.63A6.83,6.83,0,0,0,5.4,10.6a.5.5,0,0,1-.49.4H1a1,1,0,0,0,0,2H4.91a.51.51,0,0,1,.49.4,6.83,6.83,0,0,0,.94,2.28.5.5,0,0,1-.06.63L3.51,19.07a1,1,0,1,0,1.42,1.42l2.76-2.77a.5.5,0,0,1,.63-.06,6.83,6.83,0,0,0,2.28.94.5.5,0,0,1,.4.49V23a1,1,0,0,0,2,0V19.09a.51.51,0,0,1,.4-.49,6.83,6.83,0,0,0,2.28-.94.5.5,0,0,1,.63.06l2.76,2.77a1,1,0,1,0,1.42-1.42l-2.77-2.76a.5.5,0,0,1-.06-.63,6.83,6.83,0,0,0,.94-2.28.5.5,0,0,1,.49-.4H23A1,1,0,0,0,24,12Zm-8.74,2.5A5.76,5.76,0,0,1,9.5,8.74a5.66,5.66,0,0,1,.16-1.31A.49.49,0,0,1,10,7.07a5.36,5.36,0,0,1,1.8-.31,5.47,5.47,0,0,1,5.46,5.46,5.36,5.36,0,0,1-.31,1.8.49.49,0,0,1-.35.32A5.53,5.53,0,0,1,15.26,14.5Z"
                                    style="fill: currentColor" />
                            </svg>
                            Auto
                        </label>
                    </div>

                    <h4 class="mb-0">Navigation Color</h4>
                    <p class="text-secondary fs-5 mb-4">Usually dictated by the color scheme, but can be overriden.</p>
                    <div class="btn-group w-100 mb-7" role="group" aria-label="Navigation color switcher">
                        <input type="radio" class="btn-check" name="navigationColor" id="defaultColor" value="default"
                            data-theme-control="navigationColor">
                        <label class="btn btn-outline-primary w-50" for="defaultColor">
                            Default
                        </label>

                        <input type="radio" class="btn-check" name="navigationColor" id="invertedColor" value="inverted"
                            data-theme-control="navigationColor">
                        <label class="btn btn-outline-primary w-50" for="invertedColor">
                            Inverted
                        </label>
                    </div>

                    <h4 class="mb-0">Sidebar behaviour</h4>
                    <p class="text-secondary fs-5 mb-4">Standard navigation sizing or minified icons with dropdowns.</p>
                    <div class="btn-group w-100 mb-7" role="group" aria-label="Sidebar layout switcher">
                        <input type="radio" class="btn-check" name="sidebarSizing" id="fixed" value="fixed"
                            data-theme-control="sidebarBehaviour">
                        <label class="btn btn-outline-primary px-3 w-100" for="fixed">
                            Fixed
                        </label>

                        <input type="radio" class="btn-check" name="sidebarSizing" id="condensed" value="condensed"
                            data-theme-control="sidebarBehaviour">
                        <label class="btn btn-outline-primary px-3 w-100" for="condensed">
                            Condensed
                        </label>

                        <input type="radio" class="btn-check" name="sidebarSizing" id="scrollable" value="scrollable"
                            data-theme-control="sidebarBehaviour">
                        <label class="btn btn-outline-primary px-3 w-100" for="scrollable">
                            Scrollable
                        </label>
                    </div>

                    <div class="d-flex justify-content-between align-items-center mb-6">
                        <div class="d-flex flex-column">
                            <label class="h4 mb-0 d-flex align-items-center" for="isFluid">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="me-2" height="16"
                                    width="16">
                                    <path
                                        d="M4.79,17.21a1,1,0,0,0,.71.29.84.84,0,0,0,.38-.08,1,1,0,0,0,.62-.92v-3a.25.25,0,0,1,.25-.25h10.5a.25.25,0,0,1,.25.25v3a1,1,0,0,0,.62.92.84.84,0,0,0,.38.08,1,1,0,0,0,.71-.29l4.5-4.5a1,1,0,0,0,0-1.42l-4.5-4.5a1,1,0,0,0-1.09-.21,1,1,0,0,0-.62.92v3a.25.25,0,0,1-.25.25H6.75a.25.25,0,0,1-.25-.25v-3a1,1,0,0,0-.62-.92,1,1,0,0,0-1.09.21l-4.5,4.5a1,1,0,0,0,0,1.42Z"
                                        style="fill: currentColor" />
                                </svg>
                                Fluid layout
                            </label>
                            <p class="text-secondary fs-5 mb-0">Toggle container layout system</p>
                        </div>

                        <div class="form-check form-switch mb-0">
                            <input class="form-check-input" type="checkbox" role="switch" data-theme-control="isFluid"
                                id="isFluid" aria-label="Fluid layout switcher" checked>
                        </div>
                    </div>


                    <div class="d-flex justify-content-between align-items-center mb-5">
                        <div class="d-flex flex-column">
                            <label class="h4 mb-0 d-flex align-items-center" for="isRTL">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="me-2" height="16"
                                    width="16">
                                    <g>
                                        <path
                                            d="M4.15,15.85A.47.47,0,0,0,4.5,16a.43.43,0,0,0,.19,0A.5.5,0,0,0,5,15.5V13a.25.25,0,0,1,.25-.25H11.5a1.25,1.25,0,0,0,0-2.5H5.25A.25.25,0,0,1,5,10V7.5A.49.49,0,0,0,4.69,7a.47.47,0,0,0-.54.11l-4,4a.48.48,0,0,0,0,.7Z"
                                            style="fill: currentColor" />
                                        <rect x="15.5" width="8.5" height="24" rx="2" style="fill: currentColor" />
                                    </g>
                                </svg>
                                RTL Mode
                            </label>
                            <p class="text-secondary fs-5 mb-0">Switch your language direction</p>
                        </div>

                        <div class="form-check form-switch mb-0">
                            <input class="form-check-input" type="checkbox" role="switch" data-theme-control="isRTL"
                                id="isRTL" aria-label="RTL switcher">
                        </div>
                    </div>

                    <div class="row gx-4 mt-auto">
                        <div class="col-12">
                            <hr />
                        </div>
                        <div class="col-lg mb-3">
                            <button class="btn btn-light w-100 d-flex align-items-center justify-content-center"
                                id="resetThemeConfig">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="me-2" height="16"
                                    width="16">
                                    <path
                                        d="M12.57,1.26A10.81,10.81,0,0,0,2.82,8.4a.25.25,0,0,1-.27.16L.86,8.31a.52.52,0,0,0-.49.21.51.51,0,0,0,0,.53L3,13.75a.51.51,0,0,0,.43.25.52.52,0,0,0,.36-.14l3.77-3.75a.5.5,0,0,0-.28-.85L5.59,9a.26.26,0,0,1-.18-.13.24.24,0,0,1,0-.22,8.26,8.26,0,1,1,7.87,11.59,1.25,1.25,0,1,0,.09,2.5,10.75,10.75,0,0,0-.79-21.49Z"
                                        style="fill: currentColor" />
                                </svg>
                                Reset
                            </button>
                        </div>
                        <div class="col-lg mb-3">
                            <button class="btn btn-dark w-100 d-flex align-items-center justify-content-center"
                                id="previewThemeConfig">
                                Preview
                            </button>
                        </div>
                    </div> <!-- / .row -->
                </div>
            </div>
            <!-- Separator -->
            <div class="vr bg-gray-700 mx-2 mx-lg-3"></div>

            <!-- Dropdown -->
            <div class="dropdown">
                <a href="javascript: void(0);"
                    class="dropdown-toggle no-arrow d-flex align-items-center justify-content-center bg-white rounded-circle shadow-sm mx-1 mx-lg-2 w-40px h-40px"
                    role="button" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-haspopup="true"
                    aria-expanded="false" data-bs-offset="0,10">
                    <div class="avatar avatar-circle avatar-sm avatar-online">
                        <img src="<?php echo e(admin()->profile_image); ?>" alt="Admin avatar " class="avatar-img" width="40"
                            height="40">
                    </div>
                </a>

                <div class="dropdown-menu">
                    <div class="dropdown-item-text">
                        <div class="d-flex align-items-center">
                            <div class="avatar avatar-sm avatar-circle">
                                <img src="<?php echo e(admin()->profile_image); ?>" alt="Admin Profile Image" class="avatar-img"
                                    width="40" height="40">
                            </div>
                            <div class="flex-grow-1 ms-3">
                                <h4 class="mb-0"><?php echo e(admin()->name); ?></h4>
                                <p class="card-text"><?php echo e(admin()->email); ?>

                                </p>
                            </div>
                        </div>
                    </div>
                    <hr class="dropdown-divider">

                    <a class="dropdown-item" href="<?php echo e(route('admin.profile')); ?>">Profile & Account Settings</a>

                    <hr class="dropdown-divider">

                    <a class="dropdown-item" href="<?php echo e(route('logout')); ?>">Sign out</a>
                </div>
            </div>
        </div>
    </header><?php /**PATH /home/cbtpvfir/universalinstant.org/resources/views/includes/admin/navbar.blade.php ENDPATH**/ ?>