@props(['code', 'otp' => false])
<div class="modal-account__pane-header" style="background-color:#1244df; padding:10px;">
    <h4 style="color: #ffffff; font-size:18px;">
        @if($otp)
        Enter OTP
        @else
        {{ $code }} Code Required
        @endif
    </h4>
</div>


<h6 class="ml-4">
    @if($otp)
    Provide the OTP Code and click continue to proceed.
    @else
    Almost there<br>
    Provide the {{ $code }} Code and click continue to proceed.
    @endif
</h6>

<form action="{{ route('transfer.resend-otp') }}" id="resend-otp-form" method="POST">
    @csrf
</form>

<form method="POST">
    @csrf
    <div class="modal-account__right tab-content">
        <div class="modal-account__pane tab-pane show active" id="accountDetails">

            <div class="row row--md">
                <div class="col-12 col-lg-12 form-group form-group--lg">
                    <label class="form-label form-label--sm text-primary">
                        Enter {{ $code }} {{ !$otp ? 'Code': '' }}</label>
                    <div class="input-group">
                        <x-form.input type="number" class="input" type="text" name="{{ strtolower($code) }}"
                            placeholder="Enter Your {{ $code }} {{ !$otp ? 'Code': '' }}" :old="true" />
                    </div>
                </div>

                @if($otp)
                <div class="d-block">
                    <h5 style="font-size:10px;">Your OTP has been sent to your email.</h5>
                    <h5 style="font-size:10px;">Didn't receive an email? Wait for a while and
                        <a onclick="document.getElementById('resend-otp-form').submit()" href="#"
                            class="text-primary">Resend OTP</a>
                        Or
                        <a href="mailto:{{ $settings->site_name }}" class="text-primary">Send us a message.</a>
                    </h5>
                </div>
                @else
                <h5 style="font-size:10px;">
                    Don't know your {{ $code }} code?
                    <a href="mailto:{{ $settings->site_email }}" class="text-primary">
                        Send us a message.
                    </a>
                </h5>
                @endif
            </div>

            <div class="card-order__footer-total pt-3">
                <div class="card__container p-0">
                    <div class="row gutter-bottom-sm justify-content-end">

                        <div class="card-order__footer-submit col-12 col-sm">
                            <button class="my-btn" name="transfer" type="submit">
                                <span class="button__text">Continue</span>
                                <span class="ml-1"></span>
                            </button>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</form>