@extends('includes.adminlayout')

@section('content')
<div class="container-fluid">

    <!-- Title -->
    <h1 class="h2">
        Transaction Log
    </h1>

    <div class="row">

            <!-- Card -->
            <div class="card">
                <div class="card-body">
                    <!-- Table -->
                    <div class="table-responsive">
                        <table class="table table-edge table-hover table-bordered">
                            <thead class="thead-light">
                                <tr>
                                    <th>
                                        <a class="text-muted">
                                            Name
                                        </a>
                                    </th>


                                    <th>
                                        <a class="text-muted">
                                            Type
                                        </a>
                                    </th>

                                    <th>
                                        <a class="text-muted">
                                            Alert Type
                                        </a>
                                    </th>

                                    <th>
                                        <a class="text-muted">
                                            Date
                                        </a>
                                    </th>

                                    <th>
                                        <a class="text-muted">
                                            Status
                                        </a>
                                    </th>

                                    <th>
                                        <a class="text-muted">
                                            Amount
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">
                                            View Details
                                        </a>
                                    </th>
                                </tr>
                            </thead>

                            <tbody class="list">
                                @forelse ($transactions as $transaction)
                                <tr>
                                    <td class="currency"><span>{{ $transaction->user->name }}</span></td>
                                    <td>{{( ucfirst($transaction->transaction_type->value) ) }} Transfer</td>
                                    <td>
                                        <span @class([
                                            'badge',
                                            'text-bg-success' => $transaction->alert_type->isCredit(),
                                            'text-bg-danger' =>$transaction->alert_type->isDebit(),
                                        ])>
                                            {{ $transaction->alert_type }}
                                        </span>
                                    </td>
                                    <td class="currency"><span>{{$transaction->date}}</span></td>
                                    <td>
                                        <span
                                            @class([
                                                'badge',
                                                'bg-success' => $transaction->status==='successful',
                                                'bg-warning' => $transaction->status=='pending',
                                                'bg-danger' => $transaction->status=='cancelled',
                                            ])>
                                            {{ $transaction->status }}
                                        </span>
                                    </td>
                                    <td>{{ $transaction->total_amount }}</td>
                                    <td class="date"><a href="{{ route('admin.transaction-details', $transaction->txn_id) }}"
                                            target="_blank"><span class="badge text-bg-info ">View</span></a></td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="5" align="center" class="fw-bold">No pending transfers.</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div> <!-- / .table-responsive -->
                </div>
            </div> <!-- / .row -->


            <div class="mt-6 p-4">
                {{$transactions->links()}}
            </div>
    </div>
</div>
@endsection