window.onload = () => console.clear()
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(function () {
        Notify.success('Copied.')
    }, function (err) {
        Notify.failure('Error copying to clipboard.')
    });
}


document.addEventListener('alpine:init', () => {
    Alpine.data('online_deposit_form', (methods) => ({
        selected_method: {},

        selectMethod(method_id) {
            this.selected_method = methods.find(method => method.id == method_id)
        },

        copyMethodAddress() {
            if(this.selected_method.details !== undefined) {
                copyToClipboard(this.selected_method?.details?.wallet_address)
            }
        }
    }))
})