<?php

use App\Models\User;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transaction_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(User::class)->constrained()->cascadeOnDelete();
            $table->enum('alert_type', ['credit', 'debit']);
            $table->string('transaction_type');
            $table->dateTime('date');
            $table->longText('description');
            $table->string('narration');
            $table->longText('details')->nullable();
            $table->string('amount');
            $table->string('currency');
            $table->enum('creator', ['user', 'admin'])->default('user');
            $table->string('active_code')->default('tac');
            $table->string('status');
            $table->string('txn_id');
            $table->dateTime('expires_at');
            $table->string('reject_reason')->nullable()->after('expires_at');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transaction_logs');
    }
};
