-- MariaDB dump 10.19  Distrib 10.11.7-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: expertap_expertapexbank
-- ------------------------------------------------------
-- Server version	10.11.7-MariaDB-cll-lve

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `expertap_expertapexbank`
--


--
-- Table structure for table `admins`
--

DROP TABLE IF EXISTS `admins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admins` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `username` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `profile_image` varchar(255) NOT NULL DEFAULT 'https://thekivafirm.com/assets/uploads/default.jpg',
  `password` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `admins_username_unique` (`username`),
  UNIQUE KEY `admins_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admins`
--

LOCK TABLES `admins` WRITE;
/*!40000 ALTER TABLE `admins` DISABLE KEYS */;
INSERT INTO `admins` (`id`, `name`, `username`, `email`, `profile_image`, `password`, `created_at`, `updated_at`) VALUES (1,'Adminstrator','admin','support@expertapexfinance.com','/uploads/avatars/ieD7mB9W5KcIYksH4jhfeh0SSCDPLAndej5cUcaj.png','$2y$10$UCLb6XJobVEOWqJj9Hm2aexcwZfBK5pcsVRPS5NgyDlMOhhi2R/n6','2023-09-05 22:37:06','2025-04-29 13:15:09');
/*!40000 ALTER TABLE `admins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cards`
--

DROP TABLE IF EXISTS `cards`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cards` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `type` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `function` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `holder_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `number` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `expiry` date DEFAULT NULL,
  `cvv` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `pin` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `status` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `request` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cards_user_id_foreign` (`user_id`),
  CONSTRAINT `cards_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cards`
--

LOCK TABLES `cards` WRITE;
/*!40000 ALTER TABLE `cards` DISABLE KEYS */;
/*!40000 ALTER TABLE `cards` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contacts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `email` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `subject` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `message` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `others` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `status` enum('read','unread') CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'unread',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contacts`
--

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` (`id`, `name`, `email`, `subject`, `message`, `others`, `status`, `created_at`, `updated_at`) VALUES (1,'Vincent Michaels','kingtechman3v2@gmail.com','Subject','Test',NULL,'unread','2024-10-20 05:25:29','2024-10-20 05:25:29'),
(2,'Abdullah  Sajid','amount934@gmail.com','Tac code','Send me tac code',NULL,'unread','2024-11-01 06:08:09','2024-11-01 06:08:09'),
(3,'Abdullah  Sajid','amount934@gmail.com','Tac code','My all money is in account plz send me TAC code',NULL,'unread','2024-11-01 14:13:57','2024-11-01 14:13:57'),
(4,'Gabriel Siqueira','gabrielsiqueiramartins2024@gmail.com','Código tac','Onde acho o tac',NULL,'unread','2024-11-15 04:03:25','2024-11-15 04:03:25'),
(5,'Gabriel Siqueira','gabrielsiqueiramartins2024@gmail.com','Código tac','Qual meu código tac',NULL,'unread','2024-11-15 05:25:15','2024-11-15 05:25:15'),
(6,'Gabriel Siqueira','gabrielsiqueiramartins2024@gmail.com','Código tac','Qual meu código tac',NULL,'unread','2024-11-15 05:25:17','2024-11-15 05:25:17'),
(7,'Gabriel Siqueira Martins','gabrielsiqueiramartins2016@gmail.com','Conta bloqueada','Preciso de ajuda para desbloquear a conta',NULL,'unread','2024-11-23 03:11:53','2024-11-23 03:11:53'),
(8,'MANDHLENKOSI BARBARA PHILI-MASEKO','barbaramaseko@live.ca','New client','May you please assist me with a swift code.Thank you',NULL,'unread','2025-01-04 11:22:59','2025-01-04 11:22:59');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `deposit_methods`
--

DROP TABLE IF EXISTS `deposit_methods`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `deposit_methods` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `type` enum('crypto','bank') CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `min_deposit` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `max_deposit` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `details` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `is_active` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `deposit_methods`
--

LOCK TABLES `deposit_methods` WRITE;
/*!40000 ALTER TABLE `deposit_methods` DISABLE KEYS */;
/*!40000 ALTER TABLE `deposit_methods` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `deposits`
--

DROP TABLE IF EXISTS `deposits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `deposits` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `deposit_method_id` bigint(20) unsigned NOT NULL,
  `amount` varchar(255) NOT NULL,
  `photo_proof` varchar(255) DEFAULT NULL,
  `currency` varchar(255) NOT NULL,
  `comment` varchar(255) NOT NULL,
  `reject_reason` longtext DEFAULT NULL,
  `status` varchar(255) DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `deposits_user_id_foreign` (`user_id`),
  KEY `deposits_deposit_method_id_foreign` (`deposit_method_id`),
  CONSTRAINT `deposits_deposit_method_id_foreign` FOREIGN KEY (`deposit_method_id`) REFERENCES `deposit_methods` (`id`) ON DELETE CASCADE,
  CONSTRAINT `deposits_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `deposits`
--

LOCK TABLES `deposits` WRITE;
/*!40000 ALTER TABLE `deposits` DISABLE KEYS */;
/*!40000 ALTER TABLE `deposits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `loans`
--

DROP TABLE IF EXISTS `loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `loans` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `amount` varchar(255) NOT NULL,
  `monthly_income` varchar(255) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `note` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `loans_user_id_foreign` (`user_id`),
  CONSTRAINT `loans_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `loans`
--

LOCK TABLES `loans` WRITE;
/*!40000 ALTER TABLE `loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `login_histories`
--

DROP TABLE IF EXISTS `login_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `login_histories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `ip` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `login_histories_user_id_foreign` (`user_id`),
  CONSTRAINT `login_histories_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=262 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `login_histories`
--

LOCK TABLES `login_histories` WRITE;
/*!40000 ALTER TABLE `login_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `login_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notifications`
--

DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notifications` (
  `id` char(36) NOT NULL,
  `type` varchar(255) NOT NULL,
  `notifiable_type` varchar(255) NOT NULL,
  `notifiable_id` bigint(20) unsigned NOT NULL,
  `data` text NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notifications`
--

LOCK TABLES `notifications` WRITE;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
INSERT INTO `notifications` (`id`, `type`, `notifiable_type`, `notifiable_id`, `data`, `read_at`, `created_at`, `updated_at`) VALUES ('01b82807-1e22-43ed-b16a-5e6fb29a1a37','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',12,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $245,765.00 occurred in your account at 2024-12-09 13:24:11\"}','2024-12-10 19:42:07','2024-12-09 18:24:12','2024-12-10 19:42:07'),
('022011de-68cc-44e0-a10c-c6b1e078dce5','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',6,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $300,180.00 occurred in your account at 2024-12-07 08:43:58\"}',NULL,'2024-12-07 13:45:28','2024-12-07 13:45:28'),
('0245313f-2b87-4a9a-904d-1ad733bf5d79','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',26,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $30,000.00 occurred in your account at 2025-03-12 13:13:04\"}','2025-03-20 22:48:53','2025-03-13 08:21:09','2025-03-20 22:48:53'),
('02544966-f230-495e-9c17-4eebaa12354f','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',23,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  \\u20ac20,000.00 occurred in your account at 2025-02-14 18:19:53\"}',NULL,'2025-02-14 23:21:44','2025-02-14 23:21:44'),
('0427fea7-ee4b-445e-8e5f-36c1cb8da9bd','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Transaction rejected\",\"message\":\"Your transaction TXN2609709227 has been updated. The transaction status has been set to rejected\"}',NULL,'2025-02-01 15:48:12','2025-02-01 15:48:12'),
('050b21d3-1da9-49d0-8ad8-ab84a759f1c7','App\\Notifications\\User\\Welcome','App\\Models\\User',3,'{\"title\":\"Welcome to East Access Finance\",\"message\":\"Dear United nations organization , your account has been successfully created at East Access Finance.\"}',NULL,'2024-10-15 13:45:02','2024-10-15 13:45:02'),
('05177a0e-17d9-40b8-86df-1bff244bb456','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',1,'{\"title\":\"Local Transfer\",\"message\":\"A Local transaction of  $1,000.00 occurred in your account at 2024-10-28 19:43:06\"}',NULL,'2024-10-28 23:43:54','2024-10-28 23:43:54'),
('05630272-ad27-4c05-8cac-8005eb39dc97','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',2,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $13,000.00 occurred in your account at 2024-10-25 11:09:21\"}',NULL,'2024-10-25 15:09:22','2024-10-25 15:09:22'),
('05f6f211-fdf4-44e1-aeed-6d5518930d93','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',2,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $20.00 occurred in your account at 2024-11-14 19:18:59\"}',NULL,'2024-11-15 00:19:00','2024-11-15 00:19:00'),
('0805a1ea-ef48-4520-a5da-4beb7f635c0b','App\\Notifications\\User\\UserNotice','App\\Models\\User',23,'{\"title\":\"New Debit Transaction\",\"message\":\"You have received a debit of \\u20ac1,000,000.00 in your account.\"}',NULL,'2025-01-24 21:46:18','2025-01-24 21:46:18'),
('0980993b-4e34-4bda-b518-b1968c34bb1c','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of $200.00 in your account.\"}',NULL,'2025-02-15 01:18:55','2025-02-15 01:18:55'),
('098c3048-19f1-4d4d-8c00-7ddf329981da','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of $100.00 in your account.\"}',NULL,'2025-02-26 00:04:52','2025-02-26 00:04:52'),
('0a497df1-0df9-4d23-9121-5a54004bd4ff','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Transaction rejected\",\"message\":\"Your transaction TXN5971610899 has been updated. The transaction status has been set to rejected\"}','2025-02-14 23:14:10','2025-02-14 21:28:37','2025-02-14 23:14:10'),
('0aa3a484-4669-49fc-878b-faa608c2e238','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Transaction cancelled\",\"message\":\"Your transaction TXN1989384258 has been updated. The transaction status has been set to cancelled\"}',NULL,'2025-02-01 15:47:00','2025-02-01 15:47:00'),
('0c6c3897-cd62-42aa-afaa-be254d10267a','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Transaction rejected\",\"message\":\"Your transaction TXN4972686743 has been updated. The transaction status has been set to rejected\"}',NULL,'2025-02-14 23:17:20','2025-02-14 23:17:20'),
('0f29c2b8-6019-4547-b560-0bcbec4db79d','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',3,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $300,180.00 occurred in your account at 2024-10-28 18:04:10\"}',NULL,'2024-10-29 10:54:02','2024-10-29 10:54:02'),
('0f38d299-7817-4457-8e7d-2e854ead36ce','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Transaction rejected\",\"message\":\"Your transaction TXN9125272720 has been updated. The transaction status has been set to rejected\"}','2025-01-26 00:31:16','2025-01-25 15:57:38','2025-01-26 00:31:16'),
('0ff19fc0-9dec-4186-ab86-3b43fda66cb0','App\\Notifications\\User\\Welcome','App\\Models\\User',36,'{\"title\":\"Welcome to Universal Instant\",\"message\":\"Dear Aley rodsin, your account has been successfully created at Universal Instant.\"}',NULL,'2025-03-21 01:52:53','2025-03-21 01:52:53'),
('117ba717-2fb6-4bdd-8259-af6f3412d8fc','App\\Notifications\\User\\UserNotice','App\\Models\\User',23,'{\"title\":\"New Debit Transaction\",\"message\":\"You have received a debit of \\u20ac550,000.00 in your account.\"}',NULL,'2025-02-27 01:50:55','2025-02-27 01:50:55'),
('138c82f2-f0d3-468a-b573-7fc924d2b27c','App\\Notifications\\User\\UserNotice','App\\Models\\User',23,'{\"title\":\"Transaction pending\",\"message\":\"Your transaction TXN4990880742 has been updated. The transaction status has been set to pending\"}',NULL,'2025-01-25 13:42:20','2025-01-25 13:42:20'),
('147e4a51-a4ed-4945-916a-b4e42539dcc0','App\\Notifications\\User\\UserNotice','App\\Models\\User',3,'{\"title\":\"Transaction successful\",\"message\":\"Your transaction TXN2268960945 has been updated. The transaction status has been set to successful\"}',NULL,'2024-10-16 15:42:55','2024-10-16 15:42:55'),
('16af6c33-6b14-471a-a21b-d6155563581c','App\\Notifications\\User\\UserNotice','App\\Models\\User',28,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile has been successfully updated.\"}','2025-01-27 07:33:44','2025-01-26 00:07:57','2025-01-27 07:33:44'),
('17757e59-ddb8-48c5-a1f0-6cf5bc468cfd','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',8,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $300,000.00 occurred in your account at 2024-11-02 22:02:58\"}',NULL,'2024-11-03 02:02:59','2024-11-03 02:02:59'),
('17e274dd-1a46-4d08-87d1-8d34e67fc7e2','App\\Notifications\\User\\UserNotice','App\\Models\\User',7,'{\"title\":\"Card Request\",\"message\":\"We have received your card request successfully.\"}','2024-11-03 17:17:11','2024-11-01 08:14:07','2024-11-03 17:17:11'),
('187d5429-992a-46b5-bc6e-a7dca9784844','App\\Notifications\\User\\UserNotice','App\\Models\\User',23,'{\"title\":\"Transaction rejected\",\"message\":\"Your transaction TXN2501925771 has been updated. The transaction status has been set to rejected\"}',NULL,'2025-02-01 15:53:43','2025-02-01 15:53:43'),
('1c4eb9fe-27df-4808-9288-fe6615fc2a46','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of $320,000.00 in your account.\"}','2025-01-26 00:45:32','2025-01-25 10:13:33','2025-01-26 00:45:32'),
('242c95f7-bac1-4abf-b6b1-f5dafca0a544','App\\Notifications\\User\\UserNotice','App\\Models\\User',1,'{\"title\":\"Message Submitted\",\"message\":\"We have received your ticket. We will contact your shortly with this email address.\"}','2024-10-21 23:13:54','2024-10-20 05:25:33','2024-10-21 23:13:54'),
('250de961-a7db-4ebd-97d4-15e92e323f74','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Transaction rejected\",\"message\":\"Your transaction TXN1165432540 has been updated. The transaction status has been set to rejected\"}',NULL,'2025-02-14 23:17:05','2025-02-14 23:17:05'),
('294d7f7a-f7ab-4f4f-96e4-7a1449954179','App\\Notifications\\User\\UserNotice','App\\Models\\User',1,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile has been successfully updated.\"}','2024-10-19 02:13:04','2024-10-17 19:32:14','2024-10-19 02:13:04'),
('2afddb4f-ccc2-464d-af05-4bd849a98a5a','App\\Notifications\\User\\UserNotice','App\\Models\\User',23,'{\"title\":\"Your Password Has Been Changed\",\"message\":\"Your password has been changed successfully. Below is your updated login.\"}',NULL,'2025-02-17 11:23:03','2025-02-17 11:23:03'),
('2b912254-e2f1-4b93-aecb-4cfa48cd1c47','App\\Notifications\\User\\UserNotice','App\\Models\\Admin',1,'{\"title\":\"New Message Request\",\"message\":\"Gabriel Siqueira sent a message, please, login to admin to review this.\"}',NULL,'2024-11-15 05:25:18','2024-11-15 05:25:18'),
('2ca45833-dc76-45f7-9743-9efcfe7aa8d9','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',9,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $345,170.00 occurred in your account at 2024-11-06 10:49:10\"}','2024-11-06 23:21:43','2024-11-06 15:49:10','2024-11-06 23:21:43'),
('2d6dadfe-9cd5-438b-8d4e-85381ce36071','App\\Notifications\\User\\Welcome','App\\Models\\User',12,'{\"title\":\"Welcome to East Access Finance\",\"message\":\"Dear Bruno Rodrigues Souza, your account has been successfully created at East Access Finance.\"}','2024-12-06 10:08:19','2024-12-04 04:04:09','2024-12-06 10:08:19'),
('2e4849ad-e4ba-4fe2-b866-64f1a32072fa','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',2,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $20,000.00 occurred in your account at 2024-10-17 09:46:01\"}',NULL,'2024-10-17 13:46:03','2024-10-17 13:46:03'),
('2eceb7e4-7148-45c7-958c-b0b001a8ad92','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of $500.00 in your account.\"}','2025-02-23 22:34:54','2025-02-19 01:27:37','2025-02-23 22:34:54'),
('313b53c2-c3f4-4a66-bafb-4b49286ccbf9','App\\Notifications\\User\\Welcome','App\\Models\\User',4,'{\"title\":\"Welcome to East Access Finance\",\"message\":\"Dear MOHAMMAD ALKHATEB, your account has been successfully created at East Access Finance.\"}','2024-10-18 01:43:33','2024-10-16 22:32:13','2024-10-18 01:43:33'),
('3210fdcd-faeb-4e23-9c12-c5aff81fa0e3','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of $3,200.00 in your account.\"}',NULL,'2025-02-06 08:01:44','2025-02-06 08:01:44'),
('32a408fa-ab0c-4923-81a5-132779f07067','App\\Notifications\\User\\UserNotice','App\\Models\\Admin',1,'{\"title\":\"New Message Request\",\"message\":\"Gabriel Siqueira sent a message, please, login to admin to review this.\"}',NULL,'2024-11-15 05:25:16','2024-11-15 05:25:16'),
('345cbf06-14e7-462b-8aca-cf6fe93d0ec2','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Transaction rejected\",\"message\":\"Your transaction TXN5417141350 has been updated. The transaction status has been set to rejected\"}',NULL,'2025-02-27 01:56:30','2025-02-27 01:56:30'),
('34a38cba-efce-4bc0-a288-4d7e1f900e06','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',18,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $2,575,000.00 occurred in your account at 2025-01-01 23:01:08\"}','2025-01-04 07:04:40','2025-01-02 04:01:09','2025-01-04 07:04:40'),
('387e2539-67c9-405f-a36f-d0715c72a698','App\\Notifications\\User\\Welcome','App\\Models\\User',10,'{\"title\":\"Welcome to East Access Finance\",\"message\":\"Dear Hunza Abdullah, your account has been successfully created at East Access Finance.\"}','2024-11-03 18:21:20','2024-11-03 18:20:45','2024-11-03 18:21:20'),
('39106986-0ca6-4388-b49e-857d5d6a0362','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Transaction rejected\",\"message\":\"Your transaction TXN9721319958 has been updated. The transaction status has been set to rejected\"}',NULL,'2025-02-14 20:14:49','2025-02-14 20:14:49'),
('393446b2-4bff-4afb-b66b-df63b3de0a6a','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of $500.00 in your account.\"}','2025-02-23 22:34:47','2025-02-21 01:49:44','2025-02-23 22:34:47'),
('3bb9fe15-fd60-4417-8634-591c26e73cde','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',3,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $11,000.00 occurred in your account at 2024-10-25 19:26:35\"}',NULL,'2024-10-25 23:31:59','2024-10-25 23:31:59'),
('3be78dd4-cd04-4ddf-ba15-d62f15563d92','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Transaction cancelled\",\"message\":\"Your transaction TXN7054508543 has been updated. The transaction status has been set to cancelled\"}',NULL,'2025-02-14 20:14:21','2025-02-14 20:14:21'),
('3c3207b2-d809-4963-ae8d-4a9a4d770be7','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of $50,000.00 in your account.\"}',NULL,'2025-03-03 11:47:18','2025-03-03 11:47:18'),
('3cb9a0bf-0567-4a5d-a296-d506effab2dc','App\\Notifications\\User\\Welcome','App\\Models\\User',7,'{\"title\":\"Welcome to East Access Finance\",\"message\":\"Dear Abdullah  Sajid , your account has been successfully created at East Access Finance.\"}','2024-10-30 23:07:37','2024-10-30 23:00:36','2024-10-30 23:07:37'),
('3cc58da0-1afd-470e-9048-eea7887038c8','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',3,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $30,000.00 occurred in your account at 2024-10-18 07:52:43\"}',NULL,'2024-10-18 11:55:40','2024-10-18 11:55:40'),
('3dadde19-8387-48f9-be1a-04935a8eabd5','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Transaction rejected\",\"message\":\"Your transaction TXN1549765626 has been updated. The transaction status has been set to rejected\"}',NULL,'2025-02-01 15:52:27','2025-02-01 15:52:27'),
('3f257635-44df-4d83-9297-70cfe7fe79c7','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',3,'{\"title\":\"Local Transfer\",\"message\":\"A Local transaction of  $5,000.00 occurred in your account at 2024-10-18 10:17:25\"}',NULL,'2024-10-18 14:20:43','2024-10-18 14:20:43'),
('3f7316b0-d1b6-4c2a-b92a-8c0eea78dcc7','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',1,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $5,000.00 occurred in your account at 2024-10-18 07:44:08\"}','2024-10-19 02:13:04','2024-10-18 11:46:45','2024-10-19 02:13:04'),
('403fa3bb-3494-4cbf-af7c-698a1a7340a4','App\\Notifications\\User\\Welcome','App\\Models\\User',13,'{\"title\":\"Welcome to East Access Finance\",\"message\":\"Dear Ugochukwu  Christopher , your account has been successfully created at East Access Finance.\"}',NULL,'2024-12-10 16:04:28','2024-12-10 16:04:28'),
('41beaadb-fe94-458e-bf56-aa95903c1731','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile has been successfully updated.\"}','2025-01-26 00:45:47','2025-01-23 18:02:30','2025-01-26 00:45:47'),
('42c6bbd8-a0f9-434f-9e8d-7088571d6911','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"New Debit Transaction\",\"message\":\"You have received a debit of $25,000.00 in your account.\"}',NULL,'2025-03-20 17:08:16','2025-03-20 17:08:16'),
('442dce8b-5021-4ecf-8938-042565052b0a','App\\Notifications\\User\\Welcome','App\\Models\\User',1,'{\"title\":\"Welcome to East Access Finance\",\"message\":\"Dear Vincent Michaels, your account has been successfully created at East Access Finance.\"}','2024-10-19 02:13:04','2024-10-14 05:48:43','2024-10-19 02:13:04'),
('4492df2b-cf3c-4b57-9f5e-9a462a7ccd52','App\\Notifications\\User\\UserNotice','App\\Models\\User',7,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile has been successfully updated.\"}','2024-10-30 23:07:45','2024-10-30 23:01:57','2024-10-30 23:07:45'),
('45020eeb-913d-43be-a547-d5cdd4b929ef','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',5,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $173,450.00 occurred in your account at 2024-10-18 16:04:41\"}','2024-10-18 21:46:55','2024-10-18 20:04:46','2024-10-18 21:46:55'),
('4a792f0f-3389-48e0-99ae-ecd3b5074541','App\\Notifications\\User\\UserNotice','App\\Models\\User',27,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile details has been updated.\"}',NULL,'2025-01-24 12:49:45','2025-01-24 12:49:45'),
('4aff028d-228a-4883-b12f-2dedd1a5c1d6','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile has been successfully updated.\"}','2025-01-26 02:23:45','2025-01-23 18:02:31','2025-01-26 02:23:45'),
('4b204762-fff1-4d58-988d-0ae42ad0f364','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Transaction rejected\",\"message\":\"Your transaction TXN4360311922 has been updated. The transaction status has been set to rejected\"}','2025-02-26 22:04:53','2025-02-06 22:05:03','2025-02-26 22:04:53'),
('4b998da5-bbf4-4e15-bd9a-b18b95a6e24f','App\\Notifications\\User\\UserNotice','App\\Models\\User',3,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile has been successfully updated.\"}',NULL,'2024-10-15 14:10:49','2024-10-15 14:10:49'),
('4ca323b9-4de9-461a-8943-358fc02e1c62','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',3,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $173,450.00 occurred in your account at 2024-10-18 16:00:57\"}',NULL,'2024-10-18 20:04:41','2024-10-18 20:04:41'),
('4e6dfe65-2cd7-4a6d-a4e6-95c24ef71dd7','App\\Notifications\\User\\Welcome','App\\Models\\User',17,'{\"title\":\"Welcome to East Access Finance\",\"message\":\"Dear Alex Henry, your account has been successfully created at East Access Finance.\"}',NULL,'2024-12-27 15:41:31','2024-12-27 15:41:31'),
('4f98be88-f6c9-48cc-af40-1790c3e95a36','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',2,'{\"title\":\"Local Transfer\",\"message\":\"A Local transaction of  $20,000.00 occurred in your account at 2024-10-18 08:09:54\"}',NULL,'2024-10-18 12:09:55','2024-10-18 12:09:55'),
('4fb91a4c-a627-4d07-9d1a-8dccee424e54','App\\Notifications\\User\\UserNotice','App\\Models\\User',27,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile details has been updated.\"}',NULL,'2025-01-24 12:50:22','2025-01-24 12:50:22'),
('512a8625-f439-4af0-8415-f72d023c4993','App\\Notifications\\User\\Welcome','App\\Models\\User',6,'{\"title\":\"Welcome to East Access Finance\",\"message\":\"Dear Lucas  Bezerra Lima, your account has been successfully created at East Access Finance.\"}','2024-10-29 03:06:38','2024-10-24 14:13:07','2024-10-29 03:06:38'),
('52a9d4a1-042b-4201-979d-b81ec8ec8914','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Transaction cancelled\",\"message\":\"Your transaction TXN4284277275 has been updated. The transaction status has been set to cancelled\"}',NULL,'2025-02-14 20:14:08','2025-02-14 20:14:08'),
('53643621-e2e3-4384-a75a-14317fb75426','App\\Notifications\\User\\Welcome','App\\Models\\User',31,'{\"title\":\"Welcome to Universal Instant\",\"message\":\"Dear asdadef asdaf, your account has been successfully created at Universal Instant.\"}',NULL,'2025-02-17 11:59:15','2025-02-17 11:59:15'),
('54b97437-25c7-4ea9-b6f0-6d940df018e2','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',3,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $292,170.00 occurred in your account at 2024-11-14 19:27:46\"}',NULL,'2024-11-15 00:30:06','2024-11-15 00:30:06'),
('552cbc86-efd5-47c6-874c-b1b5e8bd4277','App\\Notifications\\User\\UserNotice','App\\Models\\User',12,'{\"title\":\"Card Request\",\"message\":\"We have received your card request successfully.\"}','2024-12-04 04:17:52','2024-12-04 04:14:19','2024-12-04 04:17:52'),
('5531241f-1362-41fe-bfc4-d37189b6c2e6','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of $100.00 in your account.\"}','2025-02-23 22:35:16','2025-02-15 23:07:44','2025-02-23 22:35:16'),
('55a4f8c7-65b3-4b76-a1c3-6cd6f271b0ca','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile has been successfully updated.\"}','2025-01-26 02:23:58','2025-01-22 09:06:06','2025-01-26 02:23:58'),
('564b074a-022d-43d5-a84b-5055232df134','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Transaction rejected\",\"message\":\"Your transaction TXN5844328903 has been updated. The transaction status has been set to rejected\"}',NULL,'2025-02-14 21:28:24','2025-02-14 21:28:24'),
('581b9ed1-11b1-45c4-8ce0-a2e7bfa96682','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',14,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $296,150.00 occurred in your account at 2024-12-23 21:21:53\"}',NULL,'2024-12-24 02:21:54','2024-12-24 02:21:54'),
('5bbf38b5-e7d1-4216-a4ca-b005e9c03b37','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"New Debit Transaction\",\"message\":\"You have received a debit of $25,000.00 in your account.\"}',NULL,'2025-03-20 17:08:43','2025-03-20 17:08:43'),
('5c0b4ff7-2cfd-41a1-92d4-a5fbb95e0e86','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile has been successfully updated.\"}','2025-01-26 02:24:09','2025-01-23 18:02:29','2025-01-26 02:24:09'),
('5dc7e45a-a22a-454e-8a54-68a822ecbf83','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"New Debit Transaction\",\"message\":\"You have received a debit of $25,000.00 in your account.\"}',NULL,'2025-03-20 17:07:40','2025-03-20 17:07:40'),
('5ef3b041-bb32-4d35-b6fd-928aca1d349d','App\\Notifications\\User\\Welcome','App\\Models\\User',9,'{\"title\":\"Welcome to East Access Finance\",\"message\":\"Dear Bower  Steven , your account has been successfully created at East Access Finance.\"}','2024-11-06 23:24:26','2024-11-03 17:10:17','2024-11-06 23:24:26'),
('5f899610-49e0-4267-b1f4-04f873f6cd6d','App\\Notifications\\User\\UserNotice','App\\Models\\User',25,'{\"title\":\"New Debit Transaction\",\"message\":\"You have received a debit of $10.00 in your account.\"}',NULL,'2025-01-24 21:39:19','2025-01-24 21:39:19'),
('60c58361-1cbe-40b5-b632-d8d21bf58fef','App\\Notifications\\User\\UserNotice','App\\Models\\User',35,'{\"title\":\"New Debit Transaction\",\"message\":\"You have received a debit of $33,000.00 in your account.\"}',NULL,'2025-03-13 11:40:54','2025-03-13 11:40:54'),
('6363bfa6-d575-49fa-8a55-020239231b99','App\\Notifications\\User\\Welcome','App\\Models\\User',20,'{\"title\":\"Welcome to East Access Finance\",\"message\":\"Dear ABDULMUNIM Cerkes, your account has been successfully created at East Access Finance.\"}',NULL,'2025-01-06 01:50:25','2025-01-06 01:50:25'),
('643d99ab-bb54-42ff-b502-f7efcc86d39d','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',2,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $10,000.00 occurred in your account at 2024-10-18 08:32:44\"}',NULL,'2024-10-18 12:32:45','2024-10-18 12:32:45'),
('6582d343-6264-4275-bf11-4caadb016def','App\\Notifications\\User\\UserNotice','App\\Models\\User',11,'{\"title\":\"Message Submitted\",\"message\":\"We have received your ticket. We will contact your shortly with this email address.\"}','2024-11-15 05:31:50','2024-11-15 05:25:18','2024-11-15 05:31:50'),
('6596cf90-7a5d-49bc-a459-e789e860a509','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Transaction rejected\",\"message\":\"Your transaction TXN2130357154 has been updated. The transaction status has been set to rejected\"}',NULL,'2025-03-04 22:04:46','2025-03-04 22:04:46'),
('67401fcc-c8e7-425f-8bd0-933542972a1f','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',7,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $292,150.00 occurred in your account at 2024-11-24 07:51:25\"}',NULL,'2024-11-24 12:53:11','2024-11-24 12:53:11'),
('6895596d-4fa7-406c-a967-6a01aedddd3f','App\\Notifications\\User\\UserNotice','App\\Models\\User',16,'{\"title\":\"Card Request\",\"message\":\"We have received your card request successfully.\"}',NULL,'2024-12-23 02:19:47','2024-12-23 02:19:47'),
('690f54d5-c561-4308-95d8-dd83d7384f10','App\\Notifications\\User\\UserNotice','App\\Models\\User',3,'{\"title\":\"Transaction successful\",\"message\":\"Your transaction TXN4926639850 has been updated. The transaction status has been set to successful\"}',NULL,'2024-10-16 15:44:53','2024-10-16 15:44:53'),
('6a81f763-a03c-4adb-9bdb-799d0c0e3421','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Transaction cancelled\",\"message\":\"Your transaction TXN8618111848 has been updated. The transaction status has been set to cancelled\"}',NULL,'2025-02-14 23:50:47','2025-02-14 23:50:47'),
('6c5b041e-8b8a-4f44-bf4e-64738977e19c','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Transaction rejected\",\"message\":\"Your transaction TXN8766550817 has been updated. The transaction status has been set to rejected\"}','2025-03-03 17:10:58','2025-03-03 11:48:04','2025-03-03 17:10:58'),
('6d7bad93-8545-41ae-a96a-740a54e49f43','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',3,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $5,000.00 occurred in your account at 2024-10-18 16:46:47\"}',NULL,'2024-10-18 20:49:28','2024-10-18 20:49:28'),
('6e395c3d-2ce6-4b7d-b520-0f24b184f8f6','App\\Notifications\\User\\UserNotice','App\\Models\\User',23,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of \\u20ac700,000.00 in your account.\"}',NULL,'2025-02-27 01:49:34','2025-02-27 01:49:34'),
('6ed3fd75-e68c-4796-8535-f37f86b06b73','App\\Notifications\\User\\UserNotice','App\\Models\\User',2,'{\"title\":\"Card Request\",\"message\":\"We have received your card request successfully.\"}',NULL,'2024-10-28 10:54:56','2024-10-28 10:54:56'),
('6f841b24-c2d1-4d19-aacd-8ce301a7e09d','App\\Notifications\\User\\Welcome','App\\Models\\User',15,'{\"title\":\"Welcome to East Access Finance\",\"message\":\"Dear Obiora Ndibe, your account has been successfully created at East Access Finance.\"}',NULL,'2024-12-18 19:00:04','2024-12-18 19:00:04'),
('6fd16683-61ec-494e-8e8e-9b82ee20ac9b','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of $7,180.00 in your account.\"}','2025-03-02 21:17:02','2025-01-27 11:22:56','2025-03-02 21:17:02'),
('7114b382-93b7-4308-89b1-866d03eca12e','App\\Notifications\\User\\UserNotice','App\\Models\\User',23,'{\"title\":\"Transaction rejected\",\"message\":\"Your transaction TXN3437251635 has been updated. The transaction status has been set to rejected\"}',NULL,'2025-02-14 21:28:58','2025-02-14 21:28:58'),
('715e4836-f802-4a0c-a1a5-793b20875ffa','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Transaction cancelled\",\"message\":\"Your transaction TXN9965673169 has been updated. The transaction status has been set to cancelled\"}',NULL,'2025-02-14 20:14:33','2025-02-14 20:14:33'),
('71a7916a-30b6-423f-919c-4ceebe853511','App\\Notifications\\User\\UserNotice','App\\Models\\User',18,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile has been successfully updated.\"}','2025-01-09 11:41:03','2024-12-29 11:24:54','2025-01-09 11:41:03'),
('733ff48e-03e2-4bcd-b548-3b45f071de65','App\\Notifications\\User\\UserNotice','App\\Models\\User',11,'{\"title\":\"Card Request\",\"message\":\"We have received your card request successfully.\"}','2024-11-15 04:33:15','2024-11-15 03:46:04','2024-11-15 04:33:15'),
('755639f6-962d-4ec8-b477-e35f430e4f65','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',4,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $295,187.00 occurred in your account at 2024-10-25 19:54:16\"}','2024-10-26 15:09:32','2024-10-25 23:54:17','2024-10-26 15:09:32'),
('75bc78f2-a869-44e4-bf96-308640495bae','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of $50,000.00 in your account.\"}','2025-03-02 21:16:17','2025-02-28 08:28:11','2025-03-02 21:16:17'),
('7708376c-116c-40af-adb8-adb6a68a237a','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of $300.00 in your account.\"}',NULL,'2025-03-19 21:05:53','2025-03-19 21:05:53'),
('77dd959d-a75d-49ad-ba6c-bc7ad9076b98','App\\Notifications\\User\\UserNotice','App\\Models\\User',23,'{\"title\":\"Your Password Has Been Changed\",\"message\":\"Your password has been changed successfully. Below is your updated login.\"}',NULL,'2025-02-17 11:21:47','2025-02-17 11:21:47'),
('7a246922-87df-4c8a-98d6-804d152cc2b9','App\\Notifications\\User\\Welcome','App\\Models\\User',25,'{\"title\":\"Welcome to Universal Instant\",\"message\":\"Dear Vincent Michaels, your account has been successfully created at Universal Instant.\"}',NULL,'2025-01-20 18:02:55','2025-01-20 18:02:55'),
('7a595305-e552-4f47-95ca-18acb522179a','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of $300.00 in your account.\"}',NULL,'2025-03-06 21:07:49','2025-03-06 21:07:49'),
('7af9fcf6-85f2-46d7-a244-069e88b2d33d','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',3,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $296,150.00 occurred in your account at 2024-12-23 21:20:13\"}',NULL,'2024-12-24 02:21:53','2024-12-24 02:21:53'),
('7b70b700-0c7e-4373-9c82-f223374b30e4','App\\Notifications\\User\\UserNotice','App\\Models\\User',27,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of \\u20ac750.00 in your account.\"}',NULL,'2025-01-27 11:19:22','2025-01-27 11:19:22'),
('7c777ec6-06d7-423f-9f8d-8f2db1165f15','App\\Notifications\\User\\UserNotice','App\\Models\\User',7,'{\"title\":\"New Loan Request\",\"message\":\"We have received your Loan Request of $2,000.00.\"}','2024-11-03 17:24:02','2024-11-03 17:23:39','2024-11-03 17:24:02'),
('7c9862e5-ad88-4c60-ac22-19e0f94b1d33','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',3,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $10,000.00 occurred in your account at 2024-10-18 08:30:31\"}',NULL,'2024-10-18 12:32:44','2024-10-18 12:32:44'),
('7d00042d-d263-49ce-b2c8-43a25335dfa1','App\\Notifications\\User\\UserNotice','App\\Models\\User',23,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of \\u20ac100,000.00 in your account.\"}',NULL,'2025-01-24 21:47:44','2025-01-24 21:47:44'),
('7e0e9e6d-4223-4b32-b97b-6112cb6db31a','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',23,'{\"title\":\"Local Transfer\",\"message\":\"A Local transaction of  \\u20ac50,000.00 occurred in your account at 2025-02-14 16:25:39\"}',NULL,'2025-02-14 21:27:33','2025-02-14 21:27:33'),
('7ef6deb6-5bb5-489d-a13a-1212a93a7912','App\\Notifications\\User\\Welcome','App\\Models\\User',22,'{\"title\":\"Welcome to East Access Finance\",\"message\":\"Dear United Nations Organization, your account has been successfully created at East Access Finance.\"}',NULL,'2025-01-09 04:21:27','2025-01-09 04:21:27'),
('806eb30d-3be0-4cb3-9913-aa65c4242510','App\\Notifications\\User\\UserNotice','App\\Models\\User',7,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile has been successfully updated.\"}','2024-11-01 12:51:32','2024-10-31 08:21:57','2024-11-01 12:51:32'),
('83c97c18-6535-490b-95d2-19defe06da79','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',3,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $300,180.00 occurred in your account at 2024-12-07 08:45:28\"}',NULL,'2024-12-07 13:45:28','2024-12-07 13:45:28'),
('859a63cb-4175-42e2-a155-ab07bbc556b3','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',3,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $245,765.00 occurred in your account at 2024-12-09 13:22:24\"}',NULL,'2024-12-09 18:24:11','2024-12-09 18:24:11'),
('85be2f83-6214-4ce5-9b8e-2dec3962c4e6','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',11,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $292,170.00 occurred in your account at 2024-11-14 19:30:06\"}','2024-11-15 05:14:50','2024-11-15 00:30:06','2024-11-15 05:14:50'),
('85f8bdc8-a195-4fb7-a9bb-bdd41620914b','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Transaction pending\",\"message\":\"Your transaction TXN5152941605 has been updated. The transaction status has been set to pending\"}',NULL,'2025-03-13 11:58:24','2025-03-13 11:58:24'),
('895f7367-e18b-47a5-aa14-4f2a105f1d30','App\\Notifications\\User\\UserNotice','App\\Models\\User',1,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of $3,000.00 in your account.\"}','2024-10-19 02:13:04','2024-10-16 15:44:59','2024-10-19 02:13:04'),
('8add1129-03cc-412d-8fca-04124d6cbb4e','App\\Notifications\\User\\UserNotice','App\\Models\\User',23,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of \\u20ac1,000.00 in your account.\"}',NULL,'2025-02-01 10:04:29','2025-02-01 10:04:29'),
('8c22626c-1a41-4a3a-9efb-a4efc4628084','App\\Notifications\\User\\Welcome','App\\Models\\User',30,'{\"title\":\"Welcome to Universal Instant\",\"message\":\"Dear Matilda Aval Lisa, your account has been successfully created at Universal Instant.\"}',NULL,'2025-02-07 20:24:44','2025-02-07 20:24:44'),
('8c5d3891-657c-4368-b34e-9fc9e4c81258','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Transaction rejected\",\"message\":\"Your transaction TXN9035408047 has been updated. The transaction status has been set to rejected\"}',NULL,'2025-03-03 11:45:47','2025-03-03 11:45:47'),
('8d194f1e-a785-4c72-ad33-2868bd19ed8c','App\\Notifications\\User\\UserNotice','App\\Models\\User',1,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile details has been updated.\"}','2024-10-19 02:13:04','2024-10-14 21:10:15','2024-10-19 02:13:04'),
('8d34ea6c-66b3-4d2b-a75f-a7bbe1b95a19','App\\Notifications\\User\\UserNotice','App\\Models\\User',35,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of $128,000.00 in your account.\"}','2025-03-15 02:41:43','2025-03-13 11:41:56','2025-03-15 02:41:43'),
('8d368807-9a44-4def-abd6-607ad5984de6','App\\Notifications\\User\\UserNotice','App\\Models\\User',1,'{\"title\":\"Your Password Has Been Changed\",\"message\":\"Your password has been changed successfully. Below is your updated login.\"}','2024-10-19 02:13:04','2024-10-14 21:16:38','2024-10-19 02:13:04'),
('908874ed-82ff-40cb-9567-73addef8bc65','App\\Notifications\\User\\UserNotice','App\\Models\\User',35,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of $85,000.00 in your account.\"}',NULL,'2025-03-13 11:40:24','2025-03-13 11:40:24'),
('92601c7e-2cf6-44b6-9035-f5f002a29506','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',3,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $20,000.00 occurred in your account at 2024-10-17 09:33:39\"}',NULL,'2024-10-17 13:46:01','2024-10-17 13:46:01'),
('93322542-c402-4d76-a013-f42392fc22c8','App\\Notifications\\User\\Welcome','App\\Models\\User',2,'{\"title\":\"Welcome to East Access Finance\",\"message\":\"Dear Shevchuk  Anton, your account has been successfully created at East Access Finance.\"}',NULL,'2024-10-14 11:32:18','2024-10-14 11:32:18'),
('9521d16d-8abb-477f-9897-7b73d964863b','App\\Notifications\\User\\UserNotice','App\\Models\\User',1,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile details has been updated.\"}','2024-10-19 02:13:04','2024-10-14 21:08:07','2024-10-19 02:13:04'),
('9567f3c8-57c7-4857-b62b-54d2b68655e1','App\\Notifications\\User\\UserNotice','App\\Models\\User',27,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of \\u20ac320,000.00 in your account.\"}',NULL,'2025-01-27 20:15:48','2025-01-27 20:15:48'),
('9632fe9e-4d8b-4c51-aeb2-6a9d9247d1ff','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',3,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $13,000.00 occurred in your account at 2024-10-25 11:07:53\"}',NULL,'2024-10-25 15:09:21','2024-10-25 15:09:21'),
('9729b28f-994a-442d-b786-7b4bcb8da2c9','App\\Notifications\\User\\UserNotice','App\\Models\\User',7,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile has been successfully updated.\"}','2024-11-03 17:48:47','2024-11-03 17:48:09','2024-11-03 17:48:47'),
('9802ef51-0356-4806-8d7a-ce272bfa07b1','App\\Notifications\\User\\UserNotice','App\\Models\\User',35,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of $120,000.00 in your account.\"}','2025-03-13 22:57:19','2025-03-13 11:37:47','2025-03-13 22:57:19'),
('98fc07b1-1869-4c07-86f6-9123a1ea4d99','App\\Notifications\\User\\Welcome','App\\Models\\User',35,'{\"title\":\"Welcome to Universal Instant\",\"message\":\"Dear MIA JENEA HEART, your account has been successfully created at Universal Instant.\"}',NULL,'2025-03-13 11:34:36','2025-03-13 11:34:36'),
('9a6bd5c9-d3de-46f6-bbe5-ee9dc3cf02ca','App\\Notifications\\User\\UserNotice','App\\Models\\User',11,'{\"title\":\"Message Submitted\",\"message\":\"We have received your ticket. We will contact your shortly with this email address.\"}','2024-11-15 04:33:03','2024-11-15 04:03:26','2024-11-15 04:33:03'),
('9c8cf1ff-5122-4a32-bf2e-7bfca6895aac','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',1,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $1,000.00 occurred in your account at 2024-10-25 10:40:10\"}',NULL,'2024-10-25 14:41:31','2024-10-25 14:41:31'),
('9e81b887-0b40-4d45-9d81-ecc355b6e0ee','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of $200.00 in your account.\"}',NULL,'2025-03-12 11:54:26','2025-03-12 11:54:26'),
('9ed75d18-2385-45ea-8bff-cbb186e195da','App\\Notifications\\User\\UserNotice','App\\Models\\User',14,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile has been successfully updated.\"}',NULL,'2025-01-01 20:00:47','2025-01-01 20:00:47'),
('9f2ff8d5-5ce9-44ea-93a2-35258a66d499','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',23,'{\"title\":\"Local Transfer\",\"message\":\"A Local transaction of  \\u20ac15,000.00 occurred in your account at 2025-01-25 13:25:46\"}',NULL,'2025-01-25 13:31:19','2025-01-25 13:31:19'),
('9f68fc7a-f487-429d-97d2-ea9d86426cb8','App\\Notifications\\User\\UserNotice','App\\Models\\User',7,'{\"title\":\"Message Submitted\",\"message\":\"We have received your ticket. We will contact your shortly with this email address.\"}','2024-11-01 06:08:59','2024-11-01 06:08:10','2024-11-01 06:08:59'),
('9fb563ae-3d3e-4fd3-a9eb-7f3f73b525d3','App\\Notifications\\User\\Welcome','App\\Models\\User',5,'{\"title\":\"Welcome to East Access Finance\",\"message\":\"Dear Claudenor  Silva Ribeiro , your account has been successfully created at East Access Finance.\"}','2024-10-18 02:29:15','2024-10-17 01:21:13','2024-10-18 02:29:15'),
('a124619d-606f-4aac-b03e-90f19634f82a','App\\Notifications\\User\\UserNotice','App\\Models\\User',23,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of \\u20ac4,000,000.00 in your account.\"}',NULL,'2025-02-08 01:08:05','2025-02-08 01:08:05'),
('a33a0c11-57c7-4970-b73b-043d24f6a079','App\\Notifications\\User\\UserNotice','App\\Models\\User',4,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile has been successfully updated.\"}','2024-10-20 22:03:56','2024-10-20 22:00:19','2024-10-20 22:03:56'),
('a481a77f-fcab-4650-ac51-ebd41a12d742','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of $500.00 in your account.\"}','2025-01-23 18:05:15','2025-01-23 15:46:27','2025-01-23 18:05:15'),
('a5f4417b-0c63-494d-8273-10cb7c979115','App\\Notifications\\User\\UserNotice','App\\Models\\User',18,'{\"title\":\"Message Submitted\",\"message\":\"We have received your ticket. We will contact your shortly with this email address.\"}','2025-01-05 10:28:08','2025-01-04 11:23:02','2025-01-05 10:28:08'),
('a5fd8e30-4588-4809-ab15-ed550725d5a4','App\\Notifications\\User\\UserNotice','App\\Models\\User',3,'{\"title\":\"Transaction successful\",\"message\":\"Your transaction TXN4454427112 has been updated. The transaction status has been set to successful\"}',NULL,'2024-10-16 15:44:32','2024-10-16 15:44:32'),
('a7bd696d-5f2b-49f2-9bec-e6928b358d8e','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',3,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $292,150.00 occurred in your account at 2024-11-24 07:53:11\"}',NULL,'2024-11-24 12:53:13','2024-11-24 12:53:13'),
('a836f93c-01a3-4a28-bd2b-5e7735fcfa40','App\\Notifications\\User\\Welcome','App\\Models\\User',8,'{\"title\":\"Welcome to East Access Finance\",\"message\":\"Dear Matlock  Miriam , your account has been successfully created at East Access Finance.\"}',NULL,'2024-11-03 00:52:52','2024-11-03 00:52:52'),
('a840ff27-2efa-4215-af30-c7e75135b772','App\\Notifications\\User\\Welcome','App\\Models\\User',16,'{\"title\":\"Welcome to East Access Finance\",\"message\":\"Dear Antonio Nuel, your account has been successfully created at East Access Finance.\"}',NULL,'2024-12-23 02:16:35','2024-12-23 02:16:35'),
('a9789554-1baf-42a8-a660-c5983183f4fe','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile has been successfully updated.\"}',NULL,'2025-02-27 10:48:16','2025-02-27 10:48:16'),
('a98cb9e8-074d-41f9-8669-635347cacb0d','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',26,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $30,000.00 occurred in your account at 2025-03-12 13:13:04\"}',NULL,'2025-03-13 08:21:07','2025-03-13 08:21:07'),
('a9c57aa1-f4cb-4855-bb7e-48f6cf533e93','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',11,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $292,170.00 occurred in your account at 2024-11-29 10:26:57\"}',NULL,'2024-11-29 15:28:32','2024-11-29 15:28:32'),
('aa4e3f0c-e4e8-4690-919a-9ea8db451eed','App\\Notifications\\User\\UserNotice','App\\Models\\User',23,'{\"title\":\"Transaction rejected\",\"message\":\"Your transaction TXN4990880742 has been updated. The transaction status has been set to rejected\"}',NULL,'2025-02-01 15:54:19','2025-02-01 15:54:19'),
('afc5b683-c661-4aef-9827-1acc9825ed76','App\\Notifications\\User\\UserNotice','App\\Models\\User',12,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile has been successfully updated.\"}','2024-12-06 10:02:00','2024-12-06 06:56:01','2024-12-06 10:02:00'),
('afe64935-c527-4e8e-a36e-665f40cacfdf','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',23,'{\"title\":\"Local Transfer\",\"message\":\"A Local transaction of  \\u20ac17,000.00 occurred in your account at 2025-01-25 15:44:07\"}',NULL,'2025-01-25 15:47:03','2025-01-25 15:47:03'),
('b0e82a94-0892-4cdc-9815-b5fd40dc688e','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Transaction cancelled\",\"message\":\"Your transaction TXN7118190843 has been updated. The transaction status has been set to cancelled\"}',NULL,'2025-02-14 20:13:56','2025-02-14 20:13:56'),
('b175c315-e7ba-4a46-820b-c86299242235','App\\Notifications\\User\\UserNotice','App\\Models\\User',1,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile has been successfully updated.\"}','2024-10-19 02:13:04','2024-10-17 19:32:37','2024-10-19 02:13:04'),
('b29bb822-75e7-4c40-8606-976b044416f9','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Transaction rejected\",\"message\":\"Your transaction TXN9721319958 has been updated. The transaction status has been set to rejected\"}',NULL,'2025-02-14 20:14:49','2025-02-14 20:14:49'),
('b4310128-7c0a-4eb4-aa6e-72cc35576008','App\\Notifications\\User\\UserNotice','App\\Models\\User',28,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of \\u20ac7,180.00 in your account.\"}',NULL,'2025-02-01 10:06:06','2025-02-01 10:06:06'),
('b4d4b27f-774f-4493-a4f5-0ebe65ab708c','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',2,'{\"title\":\"Local Transfer\",\"message\":\"A Local transaction of  $5,000.00 occurred in your account at 2024-10-18 10:20:43\"}',NULL,'2024-10-18 14:20:43','2024-10-18 14:20:43'),
('b56d0860-28a1-49d8-bf9e-71042ab48ed4','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',2,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $30,000.00 occurred in your account at 2024-10-18 07:55:40\"}',NULL,'2024-10-18 11:55:40','2024-10-18 11:55:40'),
('b609cf37-4915-4a32-a7a7-10995d3cba5a','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of $7,180.00 in your account.\"}','2025-01-26 00:28:08','2025-01-24 20:36:14','2025-01-26 00:28:08'),
('b63d4651-7569-4bd0-b866-6e6a63375b8c','App\\Notifications\\User\\Welcome','App\\Models\\User',11,'{\"title\":\"Welcome to East Access Finance\",\"message\":\"Dear Gabriel Siqueira, your account has been successfully created at East Access Finance.\"}','2024-11-14 13:49:38','2024-11-14 01:47:38','2024-11-14 13:49:38'),
('b67a6d4b-eded-4966-9000-cc2903649b5f','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',3,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $292,170.00 occurred in your account at 2024-11-29 10:28:32\"}',NULL,'2024-11-29 15:28:33','2024-11-29 15:28:33'),
('b7007a55-ba41-4431-8c86-2c13701553cc','App\\Notifications\\User\\UserNotice','App\\Models\\Admin',1,'{\"title\":\"New Message Request\",\"message\":\"Gabriel Siqueira sent a message, please, login to admin to review this.\"}',NULL,'2024-11-15 04:03:26','2024-11-15 04:03:26'),
('b8b747ce-c825-412f-b32b-88b2a0a88698','App\\Notifications\\User\\Welcome','App\\Models\\User',33,'{\"title\":\"Welcome to Universal Instant\",\"message\":\"Dear Miguel Costa Almeida, your account has been successfully created at Universal Instant.\"}','2025-03-07 01:19:34','2025-03-06 21:21:02','2025-03-07 01:19:34'),
('b9bf1a9a-0d2c-4cbb-9c20-d1ec0a921a68','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',19,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $296,150.00 occurred in your account at 2025-01-08 23:33:38\"}',NULL,'2025-01-09 04:33:39','2025-01-09 04:33:39'),
('bba2df01-28ea-430c-9931-931e8d83dfc6','App\\Notifications\\User\\Welcome','App\\Models\\User',14,'{\"title\":\"Welcome to East Access Finance\",\"message\":\"Dear Joao  Paulo , your account has been successfully created at East Access Finance.\"}','2024-12-12 04:57:04','2024-12-11 03:32:24','2024-12-12 04:57:04'),
('bd8ce717-5ec4-4241-95ad-59647f21b7de','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',3,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $10,000.00 occurred in your account at 2024-10-23 14:44:37\"}',NULL,'2024-10-23 18:48:03','2024-10-23 18:48:03'),
('bdd0323c-431a-49f8-a5e1-b2bac26c24b2','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',2,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $50,000.00 occurred in your account at 2024-10-24 07:48:34\"}',NULL,'2024-10-24 11:51:14','2024-10-24 11:51:14'),
('c04d6f4e-cfd0-4e76-9a91-0b3eaea6dbee','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of $200.00 in your account.\"}',NULL,'2025-03-19 11:20:39','2025-03-19 11:20:39'),
('c0a456d4-6575-4bd0-a70b-c36fecca3773','App\\Notifications\\User\\UserNotice','App\\Models\\User',23,'{\"title\":\"New Debit Transaction\",\"message\":\"You have received a debit of \\u20ac500,000.00 in your account.\"}',NULL,'2025-01-25 15:54:40','2025-01-25 15:54:40'),
('c0df5c9f-d906-438d-a474-07471ba47fd9','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',3,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $292,150.00 occurred in your account at 2024-11-01 01:42:55\"}',NULL,'2024-11-01 05:45:00','2024-11-01 05:45:00'),
('c1261a7e-ec03-445e-97dc-97f9f4c0a280','App\\Notifications\\User\\UserNotice','App\\Models\\User',3,'{\"title\":\"Your Password Has Been Changed\",\"message\":\"Your password has been changed successfully. Below is your updated login.\"}',NULL,'2024-10-15 14:51:48','2024-10-15 14:51:48'),
('c1626990-eaee-4046-ad8f-ee676f788c31','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile has been successfully updated.\"}','2025-01-26 00:27:51','2025-01-23 18:02:32','2025-01-26 00:27:51'),
('c2077ce7-592b-4637-b8b0-1e89ab1d608f','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',2,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $11,000.00 occurred in your account at 2024-10-25 19:31:59\"}',NULL,'2024-10-25 23:31:59','2024-10-25 23:31:59'),
('c28fbd26-08b5-4476-a54b-e4c38538748b','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of $7,180.00 in your account.\"}',NULL,'2025-03-04 11:54:54','2025-03-04 11:54:54'),
('c3f4d19a-bd6b-4735-b19f-e9549a0f49c2','App\\Notifications\\User\\UserNotice','App\\Models\\Admin',1,'{\"title\":\"New Message Request\",\"message\":\"MANDHLENKOSI BARBARA PHILI-MASEKO sent a message, please, login to admin to review this.\"}',NULL,'2025-01-04 11:23:02','2025-01-04 11:23:02'),
('c462c0d4-bf64-4a77-8fa7-9e46aa7f347b','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',3,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $295,187.00 occurred in your account at 2024-10-25 19:50:13\"}',NULL,'2024-10-25 23:54:16','2024-10-25 23:54:16'),
('c498c469-1538-4e47-9b6e-395f4ed58390','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',26,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $50,000.00 occurred in your account at 2025-02-26 18:18:38\"}','2025-03-01 17:57:16','2025-02-27 15:52:38','2025-03-01 17:57:16'),
('c7a664ec-8e62-43e9-81cf-fff96d42dd0b','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',1,'{\"title\":\"New International Transfer\",\"message\":\"A International transaction of  $5,000.00 occurred in your account at 2024-10-15 13:23:43\"}','2024-10-19 02:13:04','2024-10-15 17:25:58','2024-10-19 02:13:04'),
('c9784802-4a87-4ed9-aa69-a25585ed70e9','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Transaction rejected\",\"message\":\"Your transaction TXN1989384258 has been updated. The transaction status has been set to rejected\"}',NULL,'2025-02-01 15:47:31','2025-02-01 15:47:31'),
('ccc7de5d-4070-496e-811c-0b6a430ba3bc','App\\Notifications\\User\\Welcome','App\\Models\\User',32,'{\"title\":\"Welcome to Universal Instant\",\"message\":\"Dear Carlos Manuel Meireles, your account has been successfully created at Universal Instant.\"}',NULL,'2025-02-27 11:57:43','2025-02-27 11:57:43'),
('cd57969e-71e1-43bc-aaa4-f1c6fd49be1d','App\\Notifications\\User\\Welcome','App\\Models\\User',29,'{\"title\":\"Welcome to Universal Instant\",\"message\":\"Dear Michael  Collins , your account has been successfully created at Universal Instant.\"}',NULL,'2025-02-07 18:16:12','2025-02-07 18:16:12'),
('cd7d76aa-42a3-4dbf-af69-bf06518ec800','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Transaction cancelled\",\"message\":\"Your transaction TXN9304981691 has been updated. The transaction status has been set to cancelled\"}','2025-02-23 22:35:25','2025-02-14 23:50:33','2025-02-23 22:35:25'),
('ceee9415-a269-40f5-b399-eb8e2a6848c0','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',3,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $345,170.00 occurred in your account at 2024-11-06 10:47:08\"}',NULL,'2024-11-06 15:49:10','2024-11-06 15:49:10'),
('d0398545-6cd6-4cb7-8fb1-d4338b444602','App\\Notifications\\User\\UserNotice','App\\Models\\User',4,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile has been successfully updated.\"}','2024-10-20 22:03:56','2024-10-20 21:59:41','2024-10-20 22:03:56'),
('d1efc0f1-69ee-47ec-846c-a8983110fad9','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"New Debit Transaction\",\"message\":\"You have received a debit of $25,000.00 in your account.\"}',NULL,'2025-03-20 17:09:06','2025-03-20 17:09:06'),
('d28cbc11-d69c-4ddf-957b-ff4326617633','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',1,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $20.00 occurred in your account at 2024-11-14 19:17:00\"}',NULL,'2024-11-15 00:18:59','2024-11-15 00:18:59'),
('d2c5d279-4e92-4ad6-b322-28be7319123c','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of $200.00 in your account.\"}',NULL,'2025-02-28 08:27:40','2025-02-28 08:27:40'),
('d44a61e9-6045-48b6-9291-39bf655de1c8','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',1,'{\"title\":\"New International Transfer\",\"message\":\"A International transaction of  $20,000.00 occurred in your account at 2024-10-15 13:33:23\"}','2024-10-15 19:36:55','2024-10-15 17:41:23','2024-10-15 19:36:55'),
('d47f9e29-5212-4ba8-88e7-ace2ddf11a9b','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',3,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $300,000.00 occurred in your account at 2024-11-02 22:01:41\"}',NULL,'2024-11-03 02:02:58','2024-11-03 02:02:58'),
('d56fdf27-4849-407b-b02f-ab4d4157e58f','App\\Notifications\\User\\UserNotice','App\\Models\\User',35,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of $44,000.00 in your account.\"}','2025-03-13 22:56:52','2025-03-13 11:42:15','2025-03-13 22:56:52'),
('d8f055c7-3143-4068-80e4-18cbd0fe25a2','App\\Notifications\\User\\UserNotice','App\\Models\\Admin',1,'{\"title\":\"New Message Request\",\"message\":\"Abdullah  Sajid sent a message, please, login to admin to review this.\"}',NULL,'2024-11-01 06:08:10','2024-11-01 06:08:10'),
('d91c21f5-e598-407a-b12a-afe72c628101','App\\Notifications\\User\\UserNotice','App\\Models\\User',4,'{\"title\":\"Card Request\",\"message\":\"We have received your card request successfully.\"}','2024-10-18 01:43:33','2024-10-16 23:21:56','2024-10-18 01:43:33'),
('db203e9e-8876-4973-83a7-69b1eb10c259','App\\Notifications\\User\\UserNotice','App\\Models\\User',27,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of \\u20ac7,180.00 in your account.\"}',NULL,'2025-01-28 18:06:09','2025-01-28 18:06:09'),
('dbe4dcca-2d34-4976-b0b9-6d44199d94d2','App\\Notifications\\User\\UserNotice','App\\Models\\User',34,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile has been successfully updated.\"}','2025-03-14 19:20:38','2025-03-14 19:19:26','2025-03-14 19:20:38'),
('dc3cbed8-063f-4b3a-9156-fc977bd3e9f0','App\\Notifications\\User\\UserNotice','App\\Models\\Admin',1,'{\"title\":\"New Message Request\",\"message\":\"Abdullah  Sajid sent a message, please, login to admin to review this.\"}',NULL,'2024-11-01 14:14:00','2024-11-01 14:14:00'),
('dc480e03-a2c3-456c-b118-53d96a84a47b','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',3,'{\"title\":\"Local Transfer\",\"message\":\"A Local transaction of  $20,000.00 occurred in your account at 2024-10-18 08:07:45\"}',NULL,'2024-10-18 12:09:54','2024-10-18 12:09:54'),
('dce69002-f760-46cf-b7f0-dcc74243fbf4','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',7,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $292,150.00 occurred in your account at 2024-11-01 01:45:00\"}','2024-11-01 06:03:51','2024-11-01 05:45:01','2024-11-01 06:03:51'),
('dd35b651-d720-40e4-9b30-95e3fd48cdfb','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile details has been updated.\"}','2025-01-26 00:44:39','2025-01-22 08:31:09','2025-01-26 00:44:39'),
('e1dc3be0-5745-42cb-8861-9866661167fb','App\\Notifications\\User\\UserNotice','App\\Models\\User',7,'{\"title\":\"Message Submitted\",\"message\":\"We have received your ticket. We will contact your shortly with this email address.\"}','2024-11-03 17:16:59','2024-11-01 14:14:00','2024-11-03 17:16:59'),
('e1fc5e4e-c317-4b44-8875-c3de769d5156','App\\Notifications\\User\\Welcome','App\\Models\\User',18,'{\"title\":\"Welcome to East Access Finance\",\"message\":\"Dear MANDHLENKOSI BARBARA PHILI-MASEKO, your account has been successfully created at East Access Finance.\"}','2024-12-29 11:36:42','2024-12-29 11:13:42','2024-12-29 11:36:42'),
('e20ee2c4-b1cb-4ee4-93b7-dae5ea31f3db','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile has been successfully updated.\"}',NULL,'2025-02-14 20:38:47','2025-02-14 20:38:47'),
('e383a8c7-a7ed-4fb8-a697-a0562983e735','App\\Notifications\\User\\UserNotice','App\\Models\\User',23,'{\"title\":\"New Debit Transaction\",\"message\":\"You have received a debit of \\u20ac4,500,000.00 in your account.\"}',NULL,'2025-02-08 01:09:21','2025-02-08 01:09:21'),
('e39c2960-e742-482f-8abd-90bf90a6429e','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',4,'{\"title\":\"Local Transfer\",\"message\":\"A Local transaction of  $3,000.00 occurred in your account at 2024-11-25 14:29:11\"}','2025-01-03 03:11:24','2024-11-25 19:35:34','2025-01-03 03:11:24'),
('e3d5f1b4-1624-4b50-987d-662889854122','App\\Notifications\\User\\Welcome','App\\Models\\User',34,'{\"title\":\"Welcome to Universal Instant\",\"message\":\"Dear Paulo jorge Batista, your account has been successfully created at Universal Instant.\"}','2025-03-14 19:20:25','2025-03-12 00:54:43','2025-03-14 19:20:25'),
('e5514655-7c83-458c-8c1a-26e66eaed728','App\\Notifications\\User\\UserNotice','App\\Models\\User',1,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile details has been updated.\"}','2024-10-19 02:13:04','2024-10-14 21:17:26','2024-10-19 02:13:04'),
('e7176e50-8db1-46ad-9bee-3f98574aa6be','App\\Notifications\\User\\Welcome','App\\Models\\User',26,'{\"title\":\"Welcome to Universal Instant\",\"message\":\"Dear Felix Antonio Flores Mejias,, your account has been successfully created at Universal Instant.\"}','2025-01-23 18:13:45','2025-01-22 08:23:58','2025-01-23 18:13:45'),
('e7f1f5b1-bbbd-4c57-acaa-1a2c024f4ff3','App\\Notifications\\User\\UserNotice','App\\Models\\Admin',1,'{\"title\":\"New Message Request\",\"message\":\"Vincent Michaels sent a message, please, login to admin to review this.\"}',NULL,'2024-10-20 05:25:33','2024-10-20 05:25:33'),
('e909f4e1-bd5e-420d-a831-439d7b178403','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',3,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $296,150.00 occurred in your account at 2025-01-08 23:32:01\"}',NULL,'2025-01-09 04:33:38','2025-01-09 04:33:38'),
('e9b89dd6-f180-465a-8669-fd642ff04e2e','App\\Notifications\\User\\UserNotice','App\\Models\\User',11,'{\"title\":\"Message Submitted\",\"message\":\"We have received your ticket. We will contact your shortly with this email address.\"}','2024-11-15 05:36:53','2024-11-15 05:25:16','2024-11-15 05:36:53'),
('eb495cdf-e60d-4ed2-9116-f2f6f09e3504','App\\Notifications\\User\\UserNotice','App\\Models\\User',23,'{\"title\":\"Transaction pending\",\"message\":\"Your transaction TXN2501925771 has been updated. The transaction status has been set to pending\"}',NULL,'2025-01-25 15:47:44','2025-01-25 15:47:44'),
('eccc1fb0-e1ac-4006-b3bf-0346edb80869','App\\Notifications\\User\\UserNotice','App\\Models\\User',23,'{\"title\":\"New Debit Transaction\",\"message\":\"You have received a debit of \\u20ac10,000.00 in your account.\"}',NULL,'2025-01-24 21:45:11','2025-01-24 21:45:11'),
('ed2bf85f-931b-4fe1-9c62-cfefae2eec9a','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',3,'{\"title\":\"New International Transfer\",\"message\":\"A International transaction of  $50,000.00 occurred in your account at 2024-10-16 08:50:28\"}',NULL,'2024-10-16 15:34:17','2024-10-16 15:34:17'),
('ed765efd-00bd-4dc0-9dbd-005296da7f26','App\\Notifications\\User\\UserNotice','App\\Models\\User',4,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile has been successfully updated.\"}','2024-10-20 22:03:56','2024-10-20 22:01:22','2024-10-20 22:03:56'),
('edd97ea6-f764-4524-b36d-e14f210327a9','App\\Notifications\\User\\Welcome','App\\Models\\User',28,'{\"title\":\"Welcome to Universal Instant\",\"message\":\"Dear NUNO RODRIGO LOURO, your account has been successfully created at Universal Instant.\"}','2025-01-27 07:31:24','2025-01-24 20:22:33','2025-01-27 07:31:24'),
('ef277ba2-76f8-4109-b4a2-6cad7c1b0f42','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Transaction rejected\",\"message\":\"Your transaction TXN6305738146 has been updated. The transaction status has been set to rejected\"}',NULL,'2025-02-01 15:48:58','2025-02-01 15:48:58'),
('f1d5d726-3476-4b79-950d-7e847c4bb32c','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Transaction rejected\",\"message\":\"Your transaction TXN2636853878 has been updated. The transaction status has been set to rejected\"}',NULL,'2025-02-01 15:49:43','2025-02-01 15:49:43'),
('f2e225ae-f1b4-41c2-b79c-bbae7bad9fd0','App\\Notifications\\User\\UserNotice','App\\Models\\User',35,'{\"title\":\"Transaction rejected\",\"message\":\"Your transaction TXN1534273225 has been updated. The transaction status has been set to rejected\"}',NULL,'2025-03-19 11:21:08','2025-03-19 11:21:08'),
('f32e1895-ea7d-4536-874b-9667950fd558','App\\Notifications\\User\\UserNotice','App\\Models\\User',4,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile has been successfully updated.\"}','2025-01-03 03:11:31','2024-10-28 04:44:56','2025-01-03 03:11:31'),
('f35f9675-985d-4a5d-8680-692e5e987d81','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Transaction rejected\",\"message\":\"Your transaction TXN1665623311 has been updated. The transaction status has been set to rejected\"}',NULL,'2025-02-01 15:53:22','2025-02-01 15:53:22'),
('f545e5d3-1ad3-4686-a1ff-430ea7dc6dde','App\\Notifications\\User\\Welcome','App\\Models\\User',21,'{\"title\":\"Welcome to East Access Finance\",\"message\":\"Dear Liam  Christian , your account has been successfully created at East Access Finance.\"}',NULL,'2025-01-09 03:06:22','2025-01-09 03:06:22'),
('f5562754-46f9-4dfd-8ec2-7092e490e218','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of $100.00 in your account.\"}',NULL,'2025-02-07 23:26:54','2025-02-07 23:26:54'),
('f5e32d73-678b-49d3-b6ee-4d5f6bf0c8d4','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',3,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $2,575,000.00 occurred in your account at 2025-01-01 22:58:55\"}',NULL,'2025-01-02 04:01:08','2025-01-02 04:01:08'),
('f76d1d13-4ff4-4dc6-9165-3be17644a95f','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',2,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $10,000.00 occurred in your account at 2024-10-23 14:48:03\"}',NULL,'2024-10-23 18:48:03','2024-10-23 18:48:03'),
('f82777b4-1c4f-4cae-b78b-f23df3546bdd','App\\Notifications\\User\\UserNotice','App\\Models\\User',3,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile has been successfully updated.\"}',NULL,'2024-10-15 14:11:22','2024-10-15 14:11:22'),
('f8f16510-aca6-4efd-bb1c-531a9f412473','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile has been successfully updated.\"}','2025-01-26 04:39:46','2025-01-26 03:49:59','2025-01-26 04:39:46'),
('f9a98117-1882-407c-a838-b91b331b7cff','App\\Notifications\\User\\UserNotice','App\\Models\\User',35,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of $70,000.00 in your account.\"}',NULL,'2025-03-13 11:39:23','2025-03-13 11:39:23'),
('f9f8435c-dfc6-4cf7-8304-fd71a29cefcf','App\\Notifications\\User\\UserNotice','App\\Models\\User',32,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile details has been updated.\"}',NULL,'2025-02-27 11:59:03','2025-02-27 11:59:03'),
('fa80cdb8-91ce-465f-add6-357cadf24b92','App\\Notifications\\User\\UserNotice','App\\Models\\User',23,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of \\u20ac150,000,000.00 in your account.\"}',NULL,'2025-01-25 15:51:38','2025-01-25 15:51:38'),
('fc1955c0-8669-4d15-8e5d-732e47cf805e','App\\Notifications\\User\\Welcome','App\\Models\\User',19,'{\"title\":\"Welcome to East Access Finance\",\"message\":\"Dear David  Fernandez Soria , your account has been successfully created at East Access Finance.\"}',NULL,'2025-01-05 06:43:25','2025-01-05 06:43:25'),
('fc736340-3ef7-40c0-8d5f-c4081204f2c8','App\\Notifications\\User\\UserNotice','App\\Models\\User',23,'{\"title\":\"New Debit Transaction\",\"message\":\"You have received a debit of \\u20ac150,000,000.00 in your account.\"}',NULL,'2025-01-25 15:53:56','2025-01-25 15:53:56'),
('fd600d2c-ea7a-440c-95af-48205df9ae12','App\\Notifications\\User\\UserNotice','App\\Models\\User',35,'{\"title\":\"New Credit Transaction\",\"message\":\"You have received a credit of $567.00 in your account.\"}',NULL,'2025-03-13 11:39:51','2025-03-13 11:39:51'),
('fdb77c49-2a71-4c6a-bc1d-dfb552a6b84e','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',6,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $300,180.00 occurred in your account at 2024-10-29 06:54:02\"}','2024-10-29 17:25:26','2024-10-29 10:54:03','2024-10-29 17:25:26'),
('fe5f121d-a50c-4e14-b56c-708ba9501e61','App\\Notifications\\User\\UserNotice','App\\Models\\User',26,'{\"title\":\"New Debit Transaction\",\"message\":\"You have received a debit of $50,000.00 in your account.\"}',NULL,'2025-02-16 00:50:49','2025-02-16 00:50:49'),
('fe69704f-577a-4bd7-819b-868d3a4f7fc1','App\\Notifications\\User\\UserNotice','App\\Models\\User',1,'{\"title\":\"Profile Updated.\",\"message\":\"Your profile details has been updated.\"}','2024-10-19 02:13:04','2024-10-14 21:16:14','2024-10-19 02:13:04'),
('fe8235bc-c087-4022-8fdc-9c632dcb9d7b','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',2,'{\"title\":\"International Transfer\",\"message\":\"A International transaction of  $5,000.00 occurred in your account at 2024-10-18 16:49:28\"}',NULL,'2024-10-18 20:49:29','2024-10-18 20:49:29'),
('ff093627-08c7-46c6-a922-ee2d47b9839f','App\\Notifications\\User\\TransferCompleted','App\\Models\\User',4,'{\"title\":\"Local Transfer\",\"message\":\"A Local transaction of  $4,000.00 occurred in your account at 2024-11-25 14:56:19\"}','2025-01-03 03:11:04','2024-11-25 19:59:49','2025-01-03 03:11:04'),
('ffaf0fe9-d745-474b-a919-2ef365ade55b','App\\Notifications\\User\\UserNotice','App\\Models\\User',23,'{\"title\":\"New Debit Transaction\",\"message\":\"You have received a debit of \\u20ac8,900.00 in your account.\"}','2025-01-20 21:48:17','2025-01-20 21:47:50','2025-01-20 21:48:17');
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_resets`
--

DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_resets`
--

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `site_name` varchar(255) DEFAULT NULL,
  `site_logo` varchar(255) NOT NULL DEFAULT '/massets/img/logo.png',
  `alt_site_logo` varchar(255) DEFAULT NULL,
  `site_url` varchar(255) DEFAULT NULL,
  `site_favicon` varchar(255) NOT NULL DEFAULT '/massets/img/logo.png',
  `site_email` varchar(255) DEFAULT NULL,
  `site_phone` varchar(255) DEFAULT NULL,
  `location` varchar(255) DEFAULT NULL,
  `live_support` longtext DEFAULT NULL,
  `charges` varchar(255) DEFAULT NULL,
  `mail_driver` varchar(255) DEFAULT NULL,
  `mail_host` varchar(255) DEFAULT NULL,
  `mail_port` varchar(255) DEFAULT NULL,
  `mail_from` varchar(255) DEFAULT NULL,
  `mail_encryption` varchar(255) DEFAULT NULL,
  `mail_username` varchar(255) DEFAULT NULL,
  `mail_password` varchar(255) DEFAULT NULL,
  `preferences` varchar(255) DEFAULT NULL,
  `verify_email` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` (`id`, `site_name`, `site_logo`, `alt_site_logo`, `site_url`, `site_favicon`, `site_email`, `site_phone`, `location`, `live_support`, `charges`, `mail_driver`, `mail_host`, `mail_port`, `mail_from`, `mail_encryption`, `mail_username`, `mail_password`, `preferences`, `verify_email`, `created_at`, `updated_at`) VALUES (1,'Expert Apex Bank','https://expertapexfinance.com/uploads/logos/zRIDgBdht6y1FbD4ihXk9DAyQshg8VPBeEA9emzw.png','https://expertapexfinance.com/uploads/logos/nFgF8CTiH5bfuexLCTkIJUmeyoi5t4c0Qyco3ajI.png','https://expertapexfinance.com/','https://expertapexfinance.com/uploads/logos/h4XqxdzbExcZ6Ih90x9tV8HQQ092bbcHPdNyhZLf.png','support@expertapexfinance.com','00000000000','Wodantal 41 Hattingen North Rhine-Westphalia Germany','<!-- Smartsupp Live Chat script -->\r\n<script type=\"text/javascript\">\r\nvar _smartsupp = _smartsupp || {};\r\n_smartsupp.key = \'df68af2d409679c77f7f4778dcb0a6c1ca6fbe54\';\r\nwindow.smartsupp||(function(d) {\r\n  var s,c,o=smartsupp=function(){ o._.push(arguments)};o._=[];\r\n  s=d.getElementsByTagName(\'script\')[0];c=d.createElement(\'script\');\r\n  c.type=\'text/javascript\';c.charset=\'utf-8\';c.async=true;\r\n  c.src=\'https://www.smartsuppchat.com/loader.js?\';s.parentNode.insertBefore(c,s);\r\n})(document);\r\n</script>\r\n<noscript> Powered by <a href=“https://www.smartsupp.com” target=“_blank”>Smartsupp</a></noscript>','{\"local\":\"0\",\"international\":\"0\"}','smtp','cp2.tor1.ultacp.com','465','Expert Apex Finance','ssl','support@expertapexfinance.com','24tBtXKiLd$O','{\"verify_email\":false}',1,'2023-09-05 22:36:15','2025-04-29 13:18:57');
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transaction_logs`
--

DROP TABLE IF EXISTS `transaction_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `alert_type` enum('credit','debit') NOT NULL,
  `transaction_type` varchar(255) NOT NULL,
  `date` datetime NOT NULL,
  `description` longtext NOT NULL,
  `narration` varchar(255) NOT NULL,
  `details` longtext DEFAULT NULL,
  `amount` varchar(255) NOT NULL,
  `currency` varchar(255) NOT NULL,
  `creator` enum('user','admin') NOT NULL DEFAULT 'user',
  `active_code` varchar(255) DEFAULT 'tac',
  `status` varchar(255) NOT NULL,
  `txn_id` varchar(255) NOT NULL,
  `expires_at` datetime NOT NULL,
  `reject_reason` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transaction_logs_user_id_foreign` (`user_id`),
  CONSTRAINT `transaction_logs_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=202 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transaction_logs`
--

LOCK TABLES `transaction_logs` WRITE;
/*!40000 ALTER TABLE `transaction_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `transaction_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_details`
--

DROP TABLE IF EXISTS `user_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `account_balance` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  `account_type` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `date_of_birth` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `address` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `country` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `gender` enum('male','female') CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `avatar` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'http://localhost/assets/uploads/default.jpg',
  `marital_status` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `permissions` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `occupation` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `currency` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `ssn` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `codes` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_details_user_id_foreign` (`user_id`),
  CONSTRAINT `user_details_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_details`
--

LOCK TABLES `user_details` WRITE;
/*!40000 ALTER TABLE `user_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `username` varchar(255) NOT NULL,
  `account_number` varchar(255) NOT NULL,
  `phone_number` varchar(255) DEFAULT NULL,
  `is_active` varchar(255) NOT NULL DEFAULT '1',
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `password_text` varchar(255) DEFAULT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `pin` varchar(255) NOT NULL,
  `otp` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_username_unique` (`username`),
  UNIQUE KEY `users_account_number_unique` (`account_number`),
  UNIQUE KEY `users_phone_number_unique` (`phone_number`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping events for database 'expertap_expertapexbank'
--

--
-- Dumping routines for database 'expertap_expertapexbank'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-05-01 16:48:06
