<?php

namespace App\Utils;

trait Response
{
    public function response(string $status, array $message, int $httpStatus = 200, array $data = []) {
        return response()->json([
            'status' => $status,
            'message' => $message,
            'data' => $data
        ], $httpStatus);
    }

    public function errorResponse(array $errors, $httpCode=400, array $data = []) {
        return $this->response('error', [
            'errors' => $errors
        ], $httpCode, $data);
    }

    public function successResponse(string $message, $httpCode = 200, array $data = []) {
        return $this->response('success', [
            'success' => $message
        ], $httpCode, $data);
    
    }
}
