<?php

namespace App\Providers;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;

class SettingsConfigServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        if(env('APP_INSTALLED')) {
            
        if (Schema::hasTable('settings')) {
            $settings = DB::table('settings')->first();
            //checking if table is not empty
            if ($settings) {
                config([
                    'mail.mailers.smtp.driver' => $settings->mail_driver,
                    'mail.mailers.smtp.host' =>  $settings->mail_host,
                    'mail.mailers.smtp.port' =>  $settings->mail_port,
                    'mail.mailers.smtp.encryption' =>  $settings->mail_encryption,
                    'mail.mailers.smtp.username' =>  $settings->mail_username,
                    'mail.mailers.smtp.password' =>  $settings->mail_password,
                    'mail.default' => $settings->mail_driver,
                    'mail.from.address' => $settings->mail_username,
                    'mail.from.name' => $settings->mail_from,
                    'app.name' => $settings->site_name,
                    'app.url' => $settings->site_url,
                ]);
            }
        }
        }
    }
}
