<?php

namespace App\Notifications\User;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class UserNotice extends Notification {
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(public string $subject, public string $message = '', public array $action = [], public array $messages = []) {
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable) {
        return ['mail', 'database'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable) {
        return (new MailMessage)
            ->subject($this->subject)
            ->greeting("Hello, {$notifiable->name},")
            ->lineIf($this->message, $this->message)
            ->linesIf(!empty($this->messages), $this->messages)
            ->actionIf(!empty($this->action), $this->action['text'] ?? '', $this->action['url'] ?? '');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toDatabase($notifiable) {
        return [
            'title' => $this->subject,
            'message' => empty($this->message) ? $this->messages[0]: $this->message,
        ];
    }
}
