<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserDetail extends Model
{
    use HasFactory;
    
    protected $guarded = ['id'];

    protected $casts = [
      'permissions' => 'object',
      'codes' => 'object',
      'date_of_birth' => 'date',
    ];

    public function user() {
      return $this->belongsTo(User::class);
    }
}
