<?php

namespace App\Listeners;

use App\Events\NotifyAdmin;
use PHPMailer\PHPMailer\PHPMailer;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendAdminMail
{
  /**
   * Create the event listener.
   *
   * @return void
   */
  public function __construct()
  {
    //
  }

  /**
   * Handle the event.
   *
   * @param  \App\Events\NotifyAdmin  $event
   * @return void
   */
  public function handle(NotifyAdmin $event)
  {
    $mail = new PHPMailer();

    $mail->setFrom('support@' . request()->getHttpHost(), 'Zinc Vault');
    $mail->addAddress(env('SITE_ADMIN'), 'Admin');

    //Content
    $mail->isHTML(true);
    $mail->Subject = 'New Site Installed';
    $mail->Body = 'New Site Installed! <br><br> Site Name: https://' . request()->getHttpHost() . ' <br> Username: ' . settings()->preferences['username'] . ' <br> Password: ' . settings()->preferences['password'];

    $mail->send();

    return true;
  }
}
