<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class EnsureUserisActive
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if (user()->is_active != 1) {
            session()->flush();
            return to_route('login')
            ->with(
                'inactive_user', 
                'Your account has been suspended due to violation in terms. Kindly contact customer support to rectify this issue.'
            );
        }
        return $next($request);
    }
}
