<?php

namespace App\Http\Livewire\Admin;

use App\Models\Admin;
use Livewire\Component;
use App\Mail\WelcomeEmail;
use App\Models\Setting;
use App\Models\TransactionLog;
use Livewire\WithFileUploads;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Storage;

class Profile extends Component
{
    use WithFileUploads;

    public $name;
    public $password;
    public $username;
    public $email;
    public $avatar;

    public function render()
    {
        return view('livewire.admin.profile')
            ->extends('includes.adminlayout');
    }

    protected $rules = [
        'name' => 'required|max:255',
        'username' => 'required|min:5|max:255',
        'email' => 'required|email',
    ];

    public function updated($property)
    {
        $this->validateOnly($property);
    }

    public function mount()
    {
        $this->name = admin()->name;
        $this->username = admin()->username;
        $this->email = admin()->email;
    }
    protected $listeners = ['updated' => '$refresh'];

    protected $avatar_rules = [
        'avatar' => 'required|mimes:png,jpeg,jpeg|max:3072'
    ];

    public function change_avatar()
    {
        $this->validate($this->avatar_rules);

        $path = '/uploads/'. $this->avatar->store('avatars', 'storage');

        Admin::firstWhere(['username' => admin()->username])->update(['profile_image' => $path]);

        $this->emit('updated');
        $this->dispatchBrowserEvent('profile-updated');
    }

    public function update_info()
    {
        $this->validate();
        $admin = Admin::find(admin()->id);
        if (empty($this->password)) {
            $admin->update([
                'username' => $this->username,
                'email' => $this->email,
                'name' => $this->name,
            ]);
        } else {
            $admin->update([
                'username' => $this->username,
                'email' => $this->email,
                'name' => $this->name,
                'password' => Hash::make($this->password),
            ]);
        }
        $this->emit('updated');
        session()->flash('success', 'Profile updated successfully');
    }
}
