<?php

namespace App\Http\Controllers;

use App\Models\TransactionLog;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Notifications\DatabaseNotification;
use Illuminate\Support\Facades\Auth;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        if(session('login-approved')) {
            $user = User::find(auth()->id());
            return view('dashboard.index', [
                'user' => $user,
                'last_credit' => $user->transactions()->where('alert_type', 'credit')->latest()->first(),
                'last_debit' => $user->transactions()->where('alert_type', 'debit')->latest()->first(),
                'latest_transactions' => $user->transactions()->where('creator', 'user')->latest()->take(5)->get(),
            ]);
        }
        return to_route('approve-login');
    }

    public function readNotification(DatabaseNotification $notification) {
        if($notification->notifiable->id != auth()->id()) {
            abort(403);
        };
        $notification->markAsRead();

        return back()->with('success', 'Notification marked as read.');
    }

    public function readAllNotifications() {
        $user = User::find(auth()->id());
        $user->unreadNotifications->markAsRead();
        return back()->with('success', 'Notifications marked as read.');
    }
}
