<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Notifications\User\UserNotice;
use Illuminate\Http\Request;

class LoanController extends Controller
{
    public function index() {
        return view('dashboard.loan.index', [
            'user' => auth()->user()
        ]);
    }

    public function save(Request $request) {
        $data = $request->validate([
            'amount' => 'required|numeric',
            'monthly_income' => 'required|numeric',
            'subject' => 'required|max:255',
            'note' => 'required|max:255',
        ]);

        $user = User::find(auth()->id());
        $loan = $user->loans()->create($data);
        
        $message = [
            "We have received your Loan Request of $loan->total_amount.", 
            "When we have reviewed your request, we will get back to you.",
        ];


        $user->notify(new UserNotice(subject: 'New Loan Request', messages: $message));
        return back()->with('success', $this->message('Loan Request Created Successfully.'));
    }

    public function all() {
        $user = User::find(auth()->id());

        return view('dashboard.loan.all', [
            'user' => $user,
            'loans' => $user->loans()->latest()->paginate(5),
        ]);
    }
}
