<?php

namespace App\Http\Controllers\Auth;

use Illuminate\Http\Request;
use App\Events\UserLoggedIn;
use App\Models\User;
use App\Http\Controllers\Controller;


class LoginController extends Controller {
    public function index() {
        return view('auth.login');
    }

    public function logout(Request $request) {
        if(auth()->check()) {
            $user = User::find(auth()->id());
            event(new UserLoggedIn($user));
            auth('web')->logout();    
        }
        
        session()->remove('login-approved');
        
        if(!auth('admin')->check()) {
            $request->session()->invalidate();
    
            $request->session()->regenerateToken();
        }
        return to_route('login')->with('success', 'Logged out.');
    }

    public function appproveLogin()
    {
        return view('auth.approve-login', [
            'user' => auth()->user(),
        ]);
    }

    public function processLoginApproval(Request $request)
    {
        $request->validate([
            'pin' => 'required',
        ]);

        $user = auth()->user();

        if ($request->pin == $user->pin) {
            session()->put('login-approved', true);
            return to_route('dashboard');
        } else {
            return back()->withErrors([
                'pin' => 'Invalid Pin'
            ]);
        }
    }
}
