<div>
    <div class="card">
        <div class="card-body">
            <table class="table table-bordered table-responsive">
                <thead class="thead-dark">
                    <tr>
                        <th>Item</th>
                        <th>Detail</th>
                    </tr>
                </thead>
                <tbody class="list">
                    <tr>
                        <td>Transaction Type</td>
                        <td>{{transaction_type($transaction->transaction_type)}}</td>
                    </tr>
                    <tr>
                        <td>Currency</td>
                        <td class="text-capitalize">{{$transaction->currency}}</td>
                    </tr>
                    <tr>
                        <td>Amount</td>
                        <td>{{currencyLogo($transaction->currency)}}{{number_format($transaction->amount, 2)}}</td>
                    </tr>
                    <tr>
                        <td>Alert Type</td>
                        <td><span class="badge {{$transaction->alert_type=="
                                Credit"?'text-bg-success':'text-bg-danger'}}">{{$transaction->alert_type}}</span></td>
                    </tr>
                    @if($transaction->transaction_type ==1 && $transaction->cred_deb=="Debit" &&
                    $transaction->creator != "admin")
                    <tr>
                        <td>Receiver Account Number</td>
                        <td>{{$transaction->details['receiver_account_number']}}</td>
                    </tr>
                    <tr>
                        <td>Receiver Name</td>
                        <td>{{getReceiverDetail($transaction->details['receiver_account_number'])->name}}</td>
                    </tr>
                    @elseif($transaction->transaction_type ==1 && $transaction->cred_deb=="Credit" &&
                    $transaction->creator != "admin")
                    <tr>
                        <td>Sender Account Number</td>
                        <td>{{getSenderDetail($transaction->details['username'])->account_number}}</td>
                    </tr>
                    <tr>
                        <td>Sender Name</td>
                        <td>{{getSenderDetail($transaction->details['username'])->name}}</td>
                    </tr>
                    @elseif($transaction->transaction_type ==1 && $transaction->creator == "admin")
                    <tr>
                        <td colspan="2" class="text-center"><b>Transaction made by Adminstrator</b> </td>
                    </tr>
                    @endif
                    @if($transaction->transaction_type ==2)
                    <tr>
                        <td>Beneficiary Account Number</td>
                        <td>{{$transaction->details['beneficiary_acc_num']}}</td>
                    </tr>
                    <tr>
                        <td>Beneficiary Name</td>
                        <td>{{$transaction->details['beneficiary_name']}}</td>
                    </tr>

                    <tr>
                        <td>Beneficiary Bank</td>
                        <td>{{$transaction->details['beneficiary_bank']}}</td>
                    </tr>
                    <tr>
                        <td>Beneficiary Swift Code</td>
                        <td>{{$transaction->details['beneficiary_swiftcode']}}</td>
                    </tr>
                    <tr>
                        <td>Beneficiary Routing Transit Number</td>
                        <td>{{$transaction->details['routing_transit_no']}}</td>
                    </tr>
                    @endif
                    <tr>
                        <td>Reason</td>
                        <td>{{$transaction->note}}</td>
                    </tr>
                    <tr>
                        <td>Status</td>
                        <td class="status"><span
                                class="badge @if($transaction->status==1)text-bg-success @elseif($transaction->status==2)text-bg-info @else text-bg-danger @endif">{{status($transaction->status)}}</span>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2" class="text-center"><b>{{$transaction->date}}</b></td>
                    </tr>
                    @if($transaction->status==3)
                    <tr>
                        <td colspan="2" class="text-center"><button class="btn btn-info"
                                onclick="$('#{{$transaction->id}}').modal('show')"><b>Confirm Transaction</b></button>
                        </td>
                    </tr>
                    @endif
                    <td colspan="2" class="text-center">Generate Receipt <br>
                        <i id="pdf" class="material-icons p-5 cursor-pointer">picture_as_pdf</i><i id="print"
                            class="material-icons cursor-pointer">print</i>
                    </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    @if($transaction->status==3)
        @livewire('forms.international-confirm', ['transaction'=> $transaction], key($transaction->id))
    @endif
</div>