<x-mail::message>
# Dear {{ $transaction->user->name }},

Your transaction with transaction ID {{ $transaction->txn_id }} that occurred in your account on {{ $transaction->date->format('jS F, Y h:i A') }} has been completed successfully.

Below are the details of the transaction:

<x-mail::table>
| Information       | Details                              |
| ----------------- |:------------------------------------:|
| Alert             | {{ ucfirst($transaction->alert_type->value) }} |
| Transaction Type  | {{ $transaction->transaction_type->value }} |
| Date              | {{ $transaction->date->format('jS F, Y h:i A') }} |
| Note              | {{ $transaction->narration }} |
@if($transaction->details)
@foreach ($transaction->details as $detail => $value)
@if($detail !== 'total_amount' && $value)
| {{ convertText($detail) }} | {{ $value }} |
@endif
@endforeach
@endif
| Balance           | {{ $transaction->currency }}{{ number_format($transaction->user->details->account_balance, 2) }} |
</x-mail::table>

<x-mail::button :url="route('transaction.single', $transaction->txn_id)">
View Transaction
</x-mail::button>

If you have any questions, please don't hesitate to contact us at {{ settings()->site_email }}.
Kind Regards,<br>
{{ config('app.name') }}
</x-mail::message>
