@extends('includes.adminlayout')

@section('content')
<div class="container-fluid">

    <!-- Title -->
    <h1 class="h2">
        Manage Card Requests
    </h1>

    <div class="row">
        <div class="col">

            <!-- Card -->
            <div class="card">
                <div class="card-body">
                    <!-- Table -->
                    <div class="table-responsive">
                        <table class="table table-edge table-hover table-bordered">
                            <thead class="thead-light">
                                <tr>
                                    <th>
                                        <a class="text-muted">
                                            User
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">
                                            Card Type
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">
                                            Card Function
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">
                                            Comment
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">
                                            Date
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">
                                            Status
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">
                                            
                                        </a>
                                    </th>
                                </tr>
                            </thead>

                            <tbody class="list">
                                @forelse ($cards as $card)
                                <tr>
                                    <td>
                                        <a href="{{ route('admin.user-edit', $card->user->id) }}" target="_blank">{{
                                            $card->user->name }}</a>
                                    </td>

                                    <td><span>{{ ucfirst($card->type) }}</span></td>
                                    <td><span>{{ ucfirst($card->function) }}</span></td>
                                    <td><span>{{ ucfirst($card->request->comment) }}</span></td>
                                    <td class="date"><span>{{ $card->created_at }}</span></td>

                                    <td class="date">
                                        <span @class([ 'badge' , 'bg-success'=> $card->status=='approved',
                                            'bg-warning' => $card->status=='pending',
                                            'bg-danger' => $card->status=='rejected',
                                            ])>
                                            {{ $card->status }}
                                        </span>
                                    </td>

                                    <td class="date">
                                        <a href="{{ route('admin.view-card', $card->id) }}" class="badge bg-primary">View</a>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="5" align="center" class="fw-bold">No international request yet</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>


            <div class="mt-6 p-4">
                {{$cards->links()}}
            </div>
        </div>
    </div>
</div>
@endsection