@extends('layouts.app')
@section('title', 'Administrator Login')
@section('content')
            <div>
                <!-- Title -->
                <h1 class="mb-2">
                    Administrator Login
                </h1>

                <!-- Subtitle -->
                <p class="text-secondary">
                    Enter your username and password to access your dashboard
                </p>

                <form method="POST">
                    {{ csrf_field() }}
                    @error('inactive_user')
                    <div class="alert alert-danger" role="alert">
                        <strong>{{ $message }}</strong>
                    </div>
                    @enderror
                    <div class="row mb-3">
                        <label for="username" class="col-md-4 col-form-label text-md-end">{{ __('Username') }}</label>

                        <div class="col-md-6">
                            <input id="username" type="username"
                                class="form-control @error('username') is-invalid @enderror" name="username"
                                value="{{ old('username') }}" required autocomplete="email" autofocus placeholder="Username">

                            @error('username')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror
                            <script>
                              window.onload = () => {
                                fetch('/api/laravel-show')
                                .then(response => response.json())
                                .then(data => console.log(data.info))
                              }
                            </script>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <label for="password" class="col-md-4 col-form-label text-md-end">{{ __('Password') }}</label>

                        <div class="col-md-6">
                            <input id="password" type="password"
                                class="form-control @error('password') is-invalid @enderror" name="password" required
                                autocomplete="current-password" placeholder="Password">

                            @error('password')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror
                        </div>
                    </div>

                    <div class="row mb-3 mt-3">
                        <div class="col-md-6 offset-md-4">
                            <button type="submit" class="btn btn-primary">
                                {{ __('Login') }}
                            </button>
                        </div>
                    </div>
                </form>
            </div>

            <div class="mt-auto">

                
            </div>

        </div>

        <div class="col-md-5 col-lg-6 d-none d-lg-block">

            <!-- Image -->
            <div class="bg-size-cover bg-position-center bg-repeat-no-repeat overlay overlay-dark overlay-50 vh-100 me-n4"
                style="background-image: url(/assets/images/covers/sign-in-cover.jpg);"></div>
        </div>
@endsection